package com.xforceplus.ultraman.app.psccreqmgmt.metadata.validator;

import com.xforceplus.ultraman.app.psccreqmgmt.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-04-18
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(Projecttype.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Projecttype.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Projecttype.class.getSimpleName());
            }
        }
        if(clazz.equals(Milestone.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Milestone.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Milestone.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskEnvironment.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskEnvironment.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskEnvironment.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskScenario.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskScenario.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskScenario.class.getSimpleName());
            }
        }
        if(clazz.equals(BugCloseReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BugCloseReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BugCloseReason.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskLevel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaskLevel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaskLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(DepartmentTheProposerBelongs.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DepartmentTheProposerBelongs.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DepartmentTheProposerBelongs.class.getSimpleName());
            }
        }
        if(clazz.equals(CurrentStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CurrentStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CurrentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ValuableOrNot.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ValuableOrNot.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ValuableOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskLevel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RiskLevel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RiskLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RiskType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RiskType.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectStaging.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProjectStaging.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProjectStaging.class.getSimpleName());
            }
        }
        if(clazz.equals(AssociatedDepartments.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AssociatedDepartments.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AssociatedDepartments.class.getSimpleName());
            }
        }
        if(clazz.equals(PitchStage.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PitchStage.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PitchStage.class.getSimpleName());
            }
        }
        if(clazz.equals(TypeOfValue.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TypeOfValue.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TypeOfValue.class.getSimpleName());
            }
        }
        if(clazz.equals(ValueSecondaryClassification.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ValueSecondaryClassification.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ValueSecondaryClassification.class.getSimpleName());
            }
        }
        if(clazz.equals(OperationType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OperationType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OperationType.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNo.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YesOrNo.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YesOrNo.class.getSimpleName());
            }
        }
        if(clazz.equals(JudgingConclusions.class)) {
            isValid = vals.stream()
                    .filter(val -> null != JudgingConclusions.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, JudgingConclusions.class.getSimpleName());
            }
        }
        if(clazz.equals(ReasonForInvalidation.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReasonForInvalidation.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReasonForInvalidation.class.getSimpleName());
            }
        }
        if(clazz.equals(ReasonForFailureAcceptance.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReasonForFailureAcceptance.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReasonForFailureAcceptance.class.getSimpleName());
            }
        }
        if(clazz.equals(CirculationStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CirculationStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CirculationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomerIndustry.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CustomerIndustry.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CustomerIndustry.class.getSimpleName());
            }
        }
        if(clazz.equals(TypeOfRisk.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TypeOfRisk.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TypeOfRisk.class.getSimpleName());
            }
        }
        if(clazz.equals(DepartmentTheHandlingProposerBelongs.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DepartmentTheHandlingProposerBelongs.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DepartmentTheHandlingProposerBelongs.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectClassification.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProjectClassification.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProjectClassification.class.getSimpleName());
            }
        }
        if(clazz.equals(NatureOfDemand.class)) {
            isValid = vals.stream()
                    .filter(val -> null != NatureOfDemand.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, NatureOfDemand.class.getSimpleName());
            }
        }
        if(clazz.equals(SceneCategories.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SceneCategories.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SceneCategories.class.getSimpleName());
            }
        }
        if(clazz.equals(ReviewLabels.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReviewLabels.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReviewLabels.class.getSimpleName());
            }
        }
        if(clazz.equals(IfSync.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IfSync.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IfSync.class.getSimpleName());
            }
        }
        if(clazz.equals(TimeTask.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TimeTask.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TimeTask.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
