package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * circulation_status
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum CirculationStatus {

    _1("1", "已通过"),
    _2("2", "已上线"),
    _3("3", "验收不通过"),
    _4("4", "已驳回"),
    _5("5", "已作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CirculationStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CirculationStatus fromCode(String code) {
        return Stream.of(CirculationStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
