package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * customer_industry
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum CustomerIndustry {

    _1("1", "消费"),
    _2("2", "地产"),
    _3("3", "制造"),
    _4("4", "物流"),
    _5("5", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CustomerIndustry(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CustomerIndustry fromCode(String code) {
        return Stream.of(CustomerIndustry.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
