package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * department_the_handling_proposer_belongs
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum DepartmentTheHandlingProposerBelongs {

    _1("1", "PM"),
    _2("2", "CSM"),
    _3("3", "交付实施"),
    _4("4", "PS"),
    _5("5", "KAM"),
    _6("6", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DepartmentTheHandlingProposerBelongs(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DepartmentTheHandlingProposerBelongs fromCode(String code) {
        return Stream.of(DepartmentTheHandlingProposerBelongs.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
