package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * department_the_proposer_belongs
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum DepartmentTheProposerBelongs {

    PRJCENTER("PRJCENTER", "交付中心"),
    PHOENIX("PHOENIX", "销项产品线"),
    JXCPX("JXCPX", "进项产品线"),
    COOP("COOP", "协同产品线"),
    PLAT("PLAT", "业务中台-用户中心"),
    ULTRAMAN("ULTRAMAN", "奥特曼"),
    T1("T1", "税件"),
    OPENAPI("OPENAPI", "OpenAPI"),
    IP("IP", "集成平台"),
    其他("其他", "其他");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DepartmentTheProposerBelongs(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DepartmentTheProposerBelongs fromCode(String code) {
        return Stream.of(DepartmentTheProposerBelongs.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
