package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * judging_conclusions
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum JudgingConclusions {

    _1("1", "通过"),
    _2("2", "驳回");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    JudgingConclusions(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JudgingConclusions fromCode(String code) {
        return Stream.of(JudgingConclusions.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
