package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * nature_of_demand
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum NatureOfDemand {

    _1("1", "ARR看护免费需求"),
    _2("2", "仅评估人天"),
    _3("3", "SOW范围内需求"),
    _4("4", "SOW范围内需求变更");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    NatureOfDemand(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static NatureOfDemand fromCode(String code) {
        return Stream.of(NatureOfDemand.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
