package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pitch_stage
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum PitchStage {

    _1("1", "项目启动"),
    _2("2", "需求分析"),
    _3("3", "系统设计开发"),
    _4("4", "UAT测试"),
    _5("5", "上线验收"),
    _6("6", "转交运维"),
    _7("7", "系统运维"),
    _0("0", "售前BD");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PitchStage(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PitchStage fromCode(String code) {
        return Stream.of(PitchStage.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
