package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * project_staging
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum ProjectStaging {

    _1("1", "无分期"),
    _2("2", "EPC系统对接发票平台销项开票项目"),
    _3("3", "PAPCN推广"),
    _4("4", "卓越扫码开票"),
    _5("5", "震坤行+乐企数电纸票对接"),
    _6("6", "银联商务数电通道升级项目"),
    _7("7", "益海嘉里商联升级项目");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProjectStaging(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProjectStaging fromCode(String code) {
        return Stream.of(ProjectStaging.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
