package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * projecttype
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum Projecttype {

    _1("1", "A"),
    _2("2", "B"),
    _3("3", "C"),
    _4("4", "D");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Projecttype(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Projecttype fromCode(String code) {
        return Stream.of(Projecttype.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
