package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * review_labels
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum ReviewLabels {

    _1("1", "项目需求（排期）"),
    _2("2", "产品规划（暂不排期）"),
    _3("3", "评估人天（不排期）");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReviewLabels(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReviewLabels fromCode(String code) {
        return Stream.of(ReviewLabels.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
