package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * risk_level
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum RiskLevel {

    _1("1", "P0"),
    _2("2", "P1");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RiskLevel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RiskLevel fromCode(String code) {
        return Stream.of(RiskLevel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
