package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * risk_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum RiskType {

    _1("1", "延期"),
    _2("2", "超支"),
    _3("3", "验收"),
    _4("4", "商务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RiskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RiskType fromCode(String code) {
        return Stream.of(RiskType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
