package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * task_level
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum TaskLevel {

    P0("P0", "P0"),
    P1("P1", "P1"),
    P2("P2", "P2");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskLevel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskLevel fromCode(String code) {
        return Stream.of(TaskLevel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
