package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * task_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum TaskType {

    _1("1", "需求"),
    _2("2", "BUG"),
    _3("3", "任务");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaskType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaskType fromCode(String code) {
        return Stream.of(TaskType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
