package com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * type_of_risk
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public enum TypeOfRisk {

    _1("1", "成本风险"),
    _2("2", "质量风险");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TypeOfRisk(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TypeOfRisk fromCode(String code) {
        return Stream.of(TypeOfRisk.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
