package com.xforceplus.ultraman.app.psccreqmgmt.metadata.validator;

import com.xforceplus.ultraman.app.psccreqmgmt.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.psccreqmgmt.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-03-01
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(Projecttype.class)) {
            isValid = null != Projecttype.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Projecttype.class.getSimpleName());
            }
        }
        if(clazz.equals(Milestone.class)) {
            isValid = null != Milestone.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Milestone.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskType.class)) {
            isValid = null != TaskType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskEnvironment.class)) {
            isValid = null != TaskEnvironment.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskEnvironment.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskScenario.class)) {
            isValid = null != TaskScenario.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskScenario.class.getSimpleName());
            }
        }
        if(clazz.equals(BugCloseReason.class)) {
            isValid = null != BugCloseReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BugCloseReason.class.getSimpleName());
            }
        }
        if(clazz.equals(TaskLevel.class)) {
            isValid = null != TaskLevel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaskLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(DepartmentTheProposerBelongs.class)) {
            isValid = null != DepartmentTheProposerBelongs.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DepartmentTheProposerBelongs.class.getSimpleName());
            }
        }
        if(clazz.equals(CurrentStatus.class)) {
            isValid = null != CurrentStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CurrentStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ValuableOrNot.class)) {
            isValid = null != ValuableOrNot.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ValuableOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskLevel.class)) {
            isValid = null != RiskLevel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RiskLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(RiskType.class)) {
            isValid = null != RiskType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RiskType.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectStaging.class)) {
            isValid = null != ProjectStaging.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProjectStaging.class.getSimpleName());
            }
        }
        if(clazz.equals(AssociatedDepartments.class)) {
            isValid = null != AssociatedDepartments.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AssociatedDepartments.class.getSimpleName());
            }
        }
        if(clazz.equals(PitchStage.class)) {
            isValid = null != PitchStage.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PitchStage.class.getSimpleName());
            }
        }
        if(clazz.equals(TypeOfValue.class)) {
            isValid = null != TypeOfValue.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TypeOfValue.class.getSimpleName());
            }
        }
        if(clazz.equals(ValueSecondaryClassification.class)) {
            isValid = null != ValueSecondaryClassification.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ValueSecondaryClassification.class.getSimpleName());
            }
        }
        if(clazz.equals(OperationType.class)) {
            isValid = null != OperationType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OperationType.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNo.class)) {
            isValid = null != YesOrNo.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YesOrNo.class.getSimpleName());
            }
        }
        if(clazz.equals(JudgingConclusions.class)) {
            isValid = null != JudgingConclusions.fromCode(value);
            if(!isValid) {
                unValidMsg(context, JudgingConclusions.class.getSimpleName());
            }
        }
        if(clazz.equals(ReasonForInvalidation.class)) {
            isValid = null != ReasonForInvalidation.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReasonForInvalidation.class.getSimpleName());
            }
        }
        if(clazz.equals(ReasonForFailureAcceptance.class)) {
            isValid = null != ReasonForFailureAcceptance.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReasonForFailureAcceptance.class.getSimpleName());
            }
        }
        if(clazz.equals(CirculationStatus.class)) {
            isValid = null != CirculationStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CirculationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CustomerIndustry.class)) {
            isValid = null != CustomerIndustry.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CustomerIndustry.class.getSimpleName());
            }
        }
        if(clazz.equals(TypeOfRisk.class)) {
            isValid = null != TypeOfRisk.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TypeOfRisk.class.getSimpleName());
            }
        }
        if(clazz.equals(DepartmentTheHandlingProposerBelongs.class)) {
            isValid = null != DepartmentTheHandlingProposerBelongs.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DepartmentTheHandlingProposerBelongs.class.getSimpleName());
            }
        }
        if(clazz.equals(ProjectClassification.class)) {
            isValid = null != ProjectClassification.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProjectClassification.class.getSimpleName());
            }
        }
        if(clazz.equals(NatureOfDemand.class)) {
            isValid = null != NatureOfDemand.fromCode(value);
            if(!isValid) {
                unValidMsg(context, NatureOfDemand.class.getSimpleName());
            }
        }
        if(clazz.equals(SceneCategories.class)) {
            isValid = null != SceneCategories.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SceneCategories.class.getSimpleName());
            }
        }
        if(clazz.equals(ReviewLabels.class)) {
            isValid = null != ReviewLabels.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReviewLabels.class.getSimpleName());
            }
        }
        if(clazz.equals(IfSync.class)) {
            isValid = null != IfSync.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IfSync.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
