package com.xforceplus.ultraman.app.purchaseresaleservice.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-07-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaseresaleservice.entity.SaleInvoiceBaseInfo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchase-resale-service")
public interface SaleInvoiceBaseInfoFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/saleInvoiceBaseInfo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param saleInvoiceBaseInfo ${table.comment}
   * @return R
   */
  @PostMapping("/saleInvoiceBaseInfo/add")
  public R save(@RequestBody SaleInvoiceBaseInfo saleInvoiceBaseInfo);

  /**
   * 修改${table.comment}
   * @param saleInvoiceBaseInfo ${table.comment}
   * @return R
   */
  @PostMapping("/saleInvoiceBaseInfo/update")
  public R updateById(@RequestBody SaleInvoiceBaseInfo saleInvoiceBaseInfo);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/saleInvoiceBaseInfo/del/{id}" )
  public R removeById(@PathVariable Long id);

}