package com.xforceplus.ultraman.app.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_entry_rule_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-21
 */
public enum BizOrderEntryRuleType {

    _1("1", "结算单全部开票"),
    _2("2", "结算单下发票全部完成查验"),
    _3("3", "结算单下发票全部入账");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizOrderEntryRuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderEntryRuleType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
