package com.xforceplus.ultraman.app.purchaseresaleservice.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_operate_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-21
 */
public enum BizOrderOperateType {

    _0("0", "提交业务单"),
    _1("1", "修改业务单基础信息"),
    _2("2", "业务单状态变更");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizOrderOperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderOperateType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
