package com.xforceplus.ultraman.app.purchaseresaleservice.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-12-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizOrderDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单明细号
   */
  @TableField("bizOrderDetailNo")
  private String bizOrderDetailNo;

  /**
   * 明细类别
   */
  @TableField("detailCategory")
  private String detailCategory;

  /**
   * 备注
   */
  private String remark;

  /**
   * 货物及服务代码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 货物及服务名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 规格型号
   */
  private String specifications;

  /**
   * 数量单位
   */
  private String unit;

  /**
   * 税编简称
   */
  @TableField("itemShortName")
  private String itemShortName;

  /**
   * 数量
   */
  private String quantity;

  /**
   * 单价
   */
  @TableField("unitPrice")
  private String unitPrice;

  /**
   * 核验价
   */
  @TableField("checkUnitPrice")
  private String checkUnitPrice;

  /**
   * 含税金额
   */
  @TableField("amountWithTax")
  private String amountWithTax;

  /**
   * 不含税金额
   */
  @TableField("amountWithoutTax")
  private String amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private String taxAmount;

  /**
   * 税率
   */
  @TableField("taxRate")
  private String taxRate;

  /**
   * 扣除税
   */
  private String deduction;

  /**
   * 价外含税折扣
   */
  @TableField("outerDiscountWithTax")
  private String outerDiscountWithTax;

  /**
   * 价外不含税折扣
   */
  @TableField("outerDiscountWithoutTax")
  private String outerDiscountWithoutTax;

  /**
   * 价外折扣税额
   */
  @TableField("outerDiscountTax")
  private String outerDiscountTax;

  /**
   * 价内含税折扣
   */
  @TableField("innerDiscountWithTax")
  private String innerDiscountWithTax;

  /**
   * 价内不含税折扣
   */
  @TableField("innerDiscountWithoutTax")
  private String innerDiscountWithoutTax;

  /**
   * 价内折扣税额
   */
  @TableField("innerDiscountTax")
  private String innerDiscountTax;

  /**
   * 价外预付卡含税总额
   */
  @TableField("outerPrepayAmountWithTax")
  private String outerPrepayAmountWithTax;

  /**
   * 价外预付卡不含税总额
   */
  @TableField("outerPrepayAmountWithoutTax")
  private String outerPrepayAmountWithoutTax;

  /**
   * 价外预付卡折扣税额
   */
  @TableField("outerPrepayAmountTax")
  private String outerPrepayAmountTax;

  /**
   * 价内预付卡含税总额
   */
  @TableField("innerPrepayAmountWithTax")
  private String innerPrepayAmountWithTax;

  /**
   * 价内预付卡不含税总额
   */
  @TableField("innerPrepayAmountWithoutTax")
  private String innerPrepayAmountWithoutTax;

  /**
   * 价内预付卡折扣税额
   */
  @TableField("innerPrepayAmountTax")
  private String innerPrepayAmountTax;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 税编版本
   */
  @TableField("goodsTaxNoVersion")
  private String goodsTaxNoVersion;

  /**
   * 税收转换代码
   */
  @TableField("taxConvertCode")
  private String taxConvertCode;

  /**
   * 是否享受税收优惠政策
   */
  @TableField("taxPre")
  private String taxPre;

  /**
   * 享受税收优惠政策内容
   */
  @TableField("taxPreCon")
  private String taxPreCon;

  /**
   * 零税率标志
   */
  @TableField("zeroTax")
  private String zeroTax;

  /**
   * 业务扩展
   */
  @TableField("businessAttrs")
  private String businessAttrs;

  /**
   * 行业特殊票种类型
   */
  @TableField("itemTypeCode")
  private String itemTypeCode;

  /**
   * 行业特殊发票扩展信息
   */
  @TableField("specialAdditions")
  private String specialAdditions;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 扩展字段11
   */
  private String ext11;

  /**
   * 扩展字段12
   */
  private String ext12;

  /**
   * 扩展字段13
   */
  private String ext13;

  /**
   * 扩展字段14
   */
  private String ext14;

  /**
   * 扩展字段15
   */
  private String ext15;

  /**
   * 扩展字段16
   */
  private String ext16;

  /**
   * 扩展字段17
   */
  private String ext17;

  /**
   * 扩展字段18
   */
  private String ext18;

  /**
   * 扩展字段19
   */
  private String ext19;

  /**
   * 扩展字段20
   */
  private String ext20;


  /**
   * 对一关联关系 关联对象 bizOrderInfo
   */
    private Long bizOrderRelId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bizOrderDetailNo", bizOrderDetailNo);
      map.put("detailCategory", detailCategory);
      map.put("remark", remark);
      map.put("itemCode", itemCode);
      map.put("itemName", itemName);
      map.put("specifications", specifications);
      map.put("unit", unit);
      map.put("itemShortName", itemShortName);
      map.put("quantity", quantity);
      map.put("unitPrice", unitPrice);
      map.put("checkUnitPrice", checkUnitPrice);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("taxRate", taxRate);
      map.put("deduction", deduction);
      map.put("outerDiscountWithTax", outerDiscountWithTax);
      map.put("outerDiscountWithoutTax", outerDiscountWithoutTax);
      map.put("outerDiscountTax", outerDiscountTax);
      map.put("innerDiscountWithTax", innerDiscountWithTax);
      map.put("innerDiscountWithoutTax", innerDiscountWithoutTax);
      map.put("innerDiscountTax", innerDiscountTax);
      map.put("outerPrepayAmountWithTax", outerPrepayAmountWithTax);
      map.put("outerPrepayAmountWithoutTax", outerPrepayAmountWithoutTax);
      map.put("outerPrepayAmountTax", outerPrepayAmountTax);
      map.put("innerPrepayAmountWithTax", innerPrepayAmountWithTax);
      map.put("innerPrepayAmountWithoutTax", innerPrepayAmountWithoutTax);
      map.put("innerPrepayAmountTax", innerPrepayAmountTax);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("goodsTaxNoVersion", goodsTaxNoVersion);
      map.put("taxConvertCode", taxConvertCode);
      map.put("taxPre", taxPre);
      map.put("taxPreCon", taxPreCon);
      map.put("zeroTax", zeroTax);
      map.put("businessAttrs", businessAttrs);
      map.put("itemTypeCode", itemTypeCode);
      map.put("specialAdditions", specialAdditions);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("ext11", ext11);
      map.put("ext12", ext12);
      map.put("ext13", ext13);
      map.put("ext14", ext14);
      map.put("ext15", ext15);
      map.put("ext16", ext16);
      map.put("ext17", ext17);
      map.put("ext18", ext18);
      map.put("ext19", ext19);
      map.put("ext20", ext20);

       map.put("bizOrderRel.id", bizOrderRelId);
      return map;
  }

  public static BizOrderDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BizOrderDetail entity = new BizOrderDetail();
    if(map.containsKey("bizOrderDetailNo")) {
      Object obj = map.get("bizOrderDetailNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderDetailNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detailCategory")) {
      Object obj = map.get("detailCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDetailCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specifications")) {
      Object obj = map.get("specifications");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecifications((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemShortName")) {
      Object obj = map.get("itemShortName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemShortName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkUnitPrice")) {
      Object obj = map.get("checkUnitPrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeduction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outerDiscountWithTax")) {
      Object obj = map.get("outerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outerDiscountWithoutTax")) {
      Object obj = map.get("outerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterDiscountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outerDiscountTax")) {
      Object obj = map.get("outerDiscountTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterDiscountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInnerDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInnerDiscountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInnerDiscountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outerPrepayAmountWithTax")) {
      Object obj = map.get("outerPrepayAmountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterPrepayAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outerPrepayAmountWithoutTax")) {
      Object obj = map.get("outerPrepayAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterPrepayAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outerPrepayAmountTax")) {
      Object obj = map.get("outerPrepayAmountTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuterPrepayAmountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerPrepayAmountWithTax")) {
      Object obj = map.get("innerPrepayAmountWithTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInnerPrepayAmountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerPrepayAmountWithoutTax")) {
      Object obj = map.get("innerPrepayAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInnerPrepayAmountWithoutTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("innerPrepayAmountTax")) {
      Object obj = map.get("innerPrepayAmountTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInnerPrepayAmountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNoVersion")) {
      Object obj = map.get("goodsTaxNoVersion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNoVersion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxConvertCode")) {
      Object obj = map.get("taxConvertCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxConvertCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPre((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxPreCon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZeroTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessAttrs")) {
      Object obj = map.get("businessAttrs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessAttrs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemTypeCode")) {
      Object obj = map.get("itemTypeCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("specialAdditions")) {
      Object obj = map.get("specialAdditions");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialAdditions((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt20((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("bizOrderRel.id")) {
        Object obj = map.get("bizOrderRel.id");
      if(obj instanceof Long) {
        entity.setBizOrderRelId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setBizOrderRelId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bizOrderDetailNo")) {
      Object obj = map.get("bizOrderDetailNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderDetailNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("detailCategory")) {
      Object obj = map.get("detailCategory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDetailCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specifications")) {
      Object obj = map.get("specifications");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecifications((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemShortName")) {
      Object obj = map.get("itemShortName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemShortName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnitPrice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkUnitPrice")) {
      Object obj = map.get("checkUnitPrice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckUnitPrice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deduction")) {
      Object obj = map.get("deduction");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeduction((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outerDiscountWithTax")) {
      Object obj = map.get("outerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterDiscountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outerDiscountWithoutTax")) {
      Object obj = map.get("outerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterDiscountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outerDiscountTax")) {
      Object obj = map.get("outerDiscountTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterDiscountTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInnerDiscountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInnerDiscountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInnerDiscountTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outerPrepayAmountWithTax")) {
      Object obj = map.get("outerPrepayAmountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterPrepayAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outerPrepayAmountWithoutTax")) {
      Object obj = map.get("outerPrepayAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterPrepayAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("outerPrepayAmountTax")) {
      Object obj = map.get("outerPrepayAmountTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuterPrepayAmountTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerPrepayAmountWithTax")) {
      Object obj = map.get("innerPrepayAmountWithTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInnerPrepayAmountWithTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerPrepayAmountWithoutTax")) {
      Object obj = map.get("innerPrepayAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInnerPrepayAmountWithoutTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("innerPrepayAmountTax")) {
      Object obj = map.get("innerPrepayAmountTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInnerPrepayAmountTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNoVersion")) {
      Object obj = map.get("goodsTaxNoVersion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNoVersion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxConvertCode")) {
      Object obj = map.get("taxConvertCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxConvertCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPre")) {
      Object obj = map.get("taxPre");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPre((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxPreCon")) {
      Object obj = map.get("taxPreCon");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxPreCon((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zeroTax")) {
      Object obj = map.get("zeroTax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZeroTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessAttrs")) {
      Object obj = map.get("businessAttrs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessAttrs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemTypeCode")) {
      Object obj = map.get("itemTypeCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("specialAdditions")) {
      Object obj = map.get("specialAdditions");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialAdditions((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext11")) {
      Object obj = map.get("ext11");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt11((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext12")) {
      Object obj = map.get("ext12");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt12((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext13")) {
      Object obj = map.get("ext13");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt13((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext14")) {
      Object obj = map.get("ext14");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt14((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext15")) {
      Object obj = map.get("ext15");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt15((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext16")) {
      Object obj = map.get("ext16");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt16((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext17")) {
      Object obj = map.get("ext17");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt17((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext18")) {
      Object obj = map.get("ext18");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt18((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext19")) {
      Object obj = map.get("ext19");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt19((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext20")) {
      Object obj = map.get("ext20");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt20((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("bizOrderRel.id")) {
        Object obj = map.get("bizOrderRel.id");
        if(obj instanceof Long) {
          this.setBizOrderRelId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBizOrderRelId(Long.parseLong((String)obj));
        }
      }
  }
}
