package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_operate_type
 * </p>
 *
 * @author ultraman
 * @since 2023-12-18
 */
public enum BizOrderOperateType {

    _0("0", "提交业务单"),
    _1("1", "修改业务单基础信息"),
    _2("2", "业务单状态变更");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizOrderOperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderOperateType fromCode(String code) {
        return Stream.of(BizOrderOperateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
