package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_entry_rule_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-05
 */
public enum BizOrderEntryRuleType {

    _1("1", "结算单全部开票"),
    _2("2", "结算单下发票全部完成查验"),
    _3("3", "结算单下发票全部入账");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizOrderEntryRuleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderEntryRuleType fromCode(String code) {
        return Stream.of(BizOrderEntryRuleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
