package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-05
 */
public enum Status {

    _0("0", "正常"),
    _1("1", "提交销项业务单成功"),
    _2("2", "提交销项业务单失败"),
    _3("3", "部分开票成功"),
    _4("4", "全部开票成功"),
    _5("5", "销项业务单已作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Status(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Status fromCode(String code) {
        return Stream.of(Status.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
