package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_exception
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum BizOrderException {

    _1("1", "缺少项目编号"),
    _2("2", "提交销项业务单失败"),
    _3("3", "未查询到项目编号信息"),
    _4("4", "未查询到业务单明细"),
    _5("5", "销项业务单已作废"),
    _6("6", "购方公司未获取");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizOrderException(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderException fromCode(String code) {
        return Stream.of(BizOrderException.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
