package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_history_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum BizOrderHistoryStatus {

    _0("0", "回撤"),
    _1("1", "正常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizOrderHistoryStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderHistoryStatus fromCode(String code) {
        return Stream.of(BizOrderHistoryStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
