package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_operate_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum BizOrderOperateType {

    _0("0", "生成销项业务单"),
    _1("1", "修改后业务单价格信息"),
    _2("2", "业务单状态变更"),
    _3("3", "进转销业务单原始价格信息");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BizOrderOperateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderOperateType fromCode(String code) {
        return Stream.of(BizOrderOperateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
