package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_bill_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum BusinessBillType {

    AR("AR", "销项单据"),
    AP("AP", "进项单据");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessBillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessBillType fromCode(String code) {
        return Stream.of(BusinessBillType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
