package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cooperate_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum CooperateFlag {

    _0("0", "非协同"),
    _1("1", "协同");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CooperateFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CooperateFlag fromCode(String code) {
        return Stream.of(CooperateFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
