package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * item_origin
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum ItemOrigin {

    _0("0", "原始业务单"),
    _1("1", "手动拆分业务单"),
    _2("2", "手动合并业务单"),
    _3("3", "自动合并业务单"),
    _4("4", "平台手动组合"),
    _5("5", "接口API组合"),
    _6("6", "自动拆分部分开票状态明细"),
    _7("7", "虚拟明细");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ItemOrigin(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ItemOrigin fromCode(String code) {
        return Stream.of(ItemOrigin.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
