package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pre_apply_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum PreApplyStatus {

    _1("1", "正常"),
    _2("2", "申请中"),
    _3("3", "申请成功"),
    _4("4", "申请失败"),
    _9("9", "删除"),
    _5("5", "作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PreApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PreApplyStatus fromCode(String code) {
        return Stream.of(PreApplyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
