package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * receive_confirm_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum ReceiveConfirmFlag {

    _4("4", "开票待提交"),
    _5("5", "已开票"),
    _3("3", "对方确认中"),
    _1("1", "待确认"),
    _2("2", "有变更"),
    _7("7", "开票已提交"),
    _8("8", "已寄送"),
    __1("-1", "无效状态"),
    _0("0", "已作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ReceiveConfirmFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReceiveConfirmFlag fromCode(String code) {
        return Stream.of(ReceiveConfirmFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
