package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * red_apply_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum RedApplyStatus {

    _0("0", "待申请"),
    _1("1", "已申请待确认"),
    _2("2", "已确认"),
    _3("3", "作废");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RedApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RedApplyStatus fromCode(String code) {
        return Stream.of(RedApplyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
