package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * scan_back_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum ScanBackFlag {

    _0("0", "无"),
    _1("1", "已退扫"),
    _2("2", "退扫提交");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ScanBackFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ScanBackFlag fromCode(String code) {
        return Stream.of(ScanBackFlag.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
