package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * special_item_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum SpecialItemType {

    SI("SI", "销项"),
    RI("RI", "退项"),
    PA("PA", "正调整单"),
    MA("MA", "负调整单"),
    PG("PG", "赠品");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SpecialItemType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SpecialItemType fromCode(String code) {
        return Stream.of(SpecialItemType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
