package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_invoice_source
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum TaxInvoiceSource {

    SK("sk", "税控"),
    QD("qd", "全电");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxInvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSource fromCode(String code) {
        return Stream.of(TaxInvoiceSource.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
