package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_invoice_source_view
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum TaxInvoiceSourceView {

    SK("sk", "税控发票"),
    QD("qd", "数电发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxInvoiceSourceView(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSourceView fromCode(String code) {
        return Stream.of(TaxInvoiceSourceView.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
