package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * using_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum UsingStatus {

    _0("0", "未使用"),
    _1("1", "使用中");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    UsingStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static UsingStatus fromCode(String code) {
        return Stream.of(UsingStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
