package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * zero_tax
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public enum ZeroTax {

    _0("0", "出口退税"),
    _1("1", "免税"),
    _2("2", "不征税"),
    _3("3", "普通0税率");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ZeroTax(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ZeroTax fromCode(String code) {
        return Stream.of(ZeroTax.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
