package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.meta;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.xforceplus.ultraman.bocp.gen.typed.TypedField;

/**
* 对象元数据
*
* @author ultraman
* @since 2024-07-12
*/
public class EntityMeta {
    public interface OqsengineSdkOmAuditLog {
        static Long id() {
            return 1735560894293798914L;
        }
        static String code() {
            return "oqsengineSdkOmAuditLog";
        }
        TypedField<Long> OPERATOR_ID = new TypedField<>(Long.class, "operator_id");
        TypedField<String> OPERATOR_CODE = new TypedField<>(String.class, "operator_code");
        TypedField<String> OPERATOR_NAME = new TypedField<>(String.class, "operator_name");
        TypedField<String> OPERATE_TYPE = new TypedField<>(String.class, "operate_type");
        TypedField<LocalDateTime> OPERATE_TIME = new TypedField<>(LocalDateTime.class, "operate_time");
        TypedField<Long> APP_ID = new TypedField<>(Long.class, "app_id");
        TypedField<String> APP_CODE = new TypedField<>(String.class, "app_code");
        TypedField<Long> BO_ID = new TypedField<>(Long.class, "bo_id");
        TypedField<String> BO_CODE = new TypedField<>(String.class, "bo_code");
        TypedField<String> BO_NAME = new TypedField<>(String.class, "bo_name");
        TypedField<Long> ENTITY_ID = new TypedField<>(Long.class, "entity_id");
        TypedField<String> ORIGIN_DATA = new TypedField<>(String.class, "origin_data");
        TypedField<String> REQUEST_DATA = new TypedField<>(String.class, "request_data");
        TypedField<String> RESPONSE_DATA = new TypedField<>(String.class, "response_data");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface UltramanSysBoUserSetting {
        static Long id() {
            return 1735560896864907265L;
        }
        static String code() {
            return "ultramanSysBoUserSetting";
        }
        TypedField<String> CONFIG = new TypedField<>(String.class, "config");
        TypedField<String> STORE_KEY = new TypedField<>(String.class, "store_key");
        TypedField<String> EXTRA = new TypedField<>(String.class, "extra");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowInstanceLog {
        static Long id() {
            return 1735560898580377601L;
        }
        static String code() {
            return "flowInstanceLog";
        }
        TypedField<String> INSTANCE_ID = new TypedField<>(String.class, "instanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> SNAPSHOT = new TypedField<>(String.class, "snapshot");
        TypedField<String> SNAPSHOT_FORMAT = new TypedField<>(String.class, "snapshotFormat");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> FLOW_NAME = new TypedField<>(String.class, "flowName");
        TypedField<String> NODE_HISTORY = new TypedField<>(String.class, "nodeHistory");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> START_SNAPSHOT = new TypedField<>(String.class, "startSnapshot");
        TypedField<String> START_SNAPSHOT_FORMAT = new TypedField<>(String.class, "startSnapshotFormat");
        TypedField<String> COMPLETE_SNAPSHOT = new TypedField<>(String.class, "completeSnapshot");
        TypedField<String> COMPLETE_SNAPSHOT_FORMAT = new TypedField<>(String.class, "completeSnapshotFormat");
        TypedField<String> EXTEND_LOG = new TypedField<>(String.class, "extendLog");
        TypedField<String> PARENT_INSTANCE_ID = new TypedField<>(String.class, "parentInstanceId");
        TypedField<String> PARENT_NODE_ID = new TypedField<>(String.class, "parentNodeId");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface FlowReplayLog {
        static Long id() {
            return 1735560901684162562L;
        }
        static String code() {
            return "flowReplayLog";
        }
        TypedField<String> FLOW_INSTANCE_ID = new TypedField<>(String.class, "flowInstanceId");
        TypedField<String> FLOW_CODE = new TypedField<>(String.class, "flowCode");
        TypedField<String> ERROR_MSG = new TypedField<>(String.class, "errorMsg");
        TypedField<String> EXCEPTION_TRACE = new TypedField<>(String.class, "exceptionTrace");
        TypedField<String> ERROR_NODE_ID = new TypedField<>(String.class, "errorNodeId");
        TypedField<Boolean> ROLLBACK = new TypedField<>(Boolean.class, "rollback");
        TypedField<String> ROLLBACK_NODE_ID = new TypedField<>(String.class, "rollbackNodeId");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface BizOrderInfo {
        static Long id() {
            return 1736569317803167745L;
        }
        static String code() {
            return "bizOrderInfo";
        }
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerBankAccount");
        TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "bizOrderNo");
        TypedField<String> RELATED_FLAG = new TypedField<>(String.class, "relatedFlag");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "sellerOrgCode");
        TypedField<String> BUYER_ORG_CODE = new TypedField<>(String.class, "buyerOrgCode");
        TypedField<String> BUYER_TYPE = new TypedField<>(String.class, "buyerType");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "outerDiscountWithTax");
        TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "outerDiscountWithoutTax");
        TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "innerDiscountWithTax");
        TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "innerDiscountWithoutTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "outerPrepayAmountWithTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "outerPrepayAmountWithoutTax");
        TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "innerPrepayAmountWithTax");
        TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "innerPrepayAmountWithoutTax");
        TypedField<String> REVIEWER = new TypedField<>(String.class, "reviewer");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> ISSUER = new TypedField<>(String.class, "issuer");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "originalInvoiceType");
        TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "originalDateIssued");
        TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "redLetterNumber");
        TypedField<String> REVERSE_REASON = new TypedField<>(String.class, "reverseReason");
        TypedField<String> NON_ISSUE_REASON = new TypedField<>(String.class, "nonIssueReason");
        TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "businessAttrs");
        TypedField<String> MESSAGE = new TypedField<>(String.class, "message");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "buyerBankName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "buyerAddress");
        TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "buyerBankAccount");
        TypedField<String> BUYER_NO = new TypedField<>(String.class, "buyerNo");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "taxInvoiceSource");
        TypedField<String> BIZ_ORDER_ID = new TypedField<>(String.class, "bizOrderId");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TEL = new TypedField<>(String.class, "buyerTel");
        TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "conversionStatus");
        TypedField<String> PROJECT_NO = new TypedField<>(String.class, "projectNo");
        TypedField<String> RULE_CONFIG = new TypedField<>(String.class, "ruleConfig");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "pricingMethod");
        TypedField<String> CUSTOMER_BIZ_ORDER_CATEGORY = new TypedField<>(String.class, "customerBizOrderCategory");
        TypedField<BigDecimal> PRICE_ADJUSTMENT_RATIO = new TypedField<>(BigDecimal.class, "priceAdjustmentRatio");
        TypedField<String> ORIGINAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "originalAmountWithTax");
        TypedField<String> ORIGINAL_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "originalAmountWithoutTax");
        TypedField<String> ORIGINAL_TAX_AMOUNT = new TypedField<>(String.class, "originalTaxAmount");
        TypedField<String> ORIGINAL_TYPE = new TypedField<>(String.class, "originalType");
        TypedField<String> ORIGINAL_BIZ_ORDER_NO = new TypedField<>(String.class, "originalBizOrderNo");
        TypedField<String> EXCEPTION_MESSAGE = new TypedField<>(String.class, "exceptionMessage");
        /**
         * 对一关联关系 关联对象 bizOrderInfo
         */
        TypedField<Long> ORIGINAL_REL_ID = new TypedField<>(Long.class, "originalRel.id");
        /**
         * 对一关联关系 关联对象 casInfo
         */
        TypedField<Long> BIZ_ORDER_AND_CAS_RELATIONSHIP_ID = new TypedField<>(Long.class, "bizOrderAndCasRelationship.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface ORIGINAL_REL {
                static String code () {
                    return "originalRel" ;
                }
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "originalRel.sellerName");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "originalRel.sellerBankName");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "originalRel.sellerTel");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "originalRel.sellerNo");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "originalRel.sellerAddress");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "originalRel.sellerTaxNo");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "originalRel.sellerBankAccount");
                TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "originalRel.bizOrderNo");
                TypedField<String> RELATED_FLAG = new TypedField<>(String.class, "originalRel.relatedFlag");
                TypedField<String> STATUS = new TypedField<>(String.class, "originalRel.status");
                TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "originalRel.sellerOrgCode");
                TypedField<String> BUYER_ORG_CODE = new TypedField<>(String.class, "originalRel.buyerOrgCode");
                TypedField<String> BUYER_TYPE = new TypedField<>(String.class, "originalRel.buyerType");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "originalRel.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "originalRel.amountWithoutTax");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "originalRel.taxAmount");
                TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "originalRel.outerDiscountWithTax");
                TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "originalRel.outerDiscountWithoutTax");
                TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "originalRel.innerDiscountWithTax");
                TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "originalRel.innerDiscountWithoutTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "originalRel.outerPrepayAmountWithTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "originalRel.outerPrepayAmountWithoutTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "originalRel.innerPrepayAmountWithTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "originalRel.innerPrepayAmountWithoutTax");
                TypedField<String> REVIEWER = new TypedField<>(String.class, "originalRel.reviewer");
                TypedField<String> PAYEE = new TypedField<>(String.class, "originalRel.payee");
                TypedField<String> ISSUER = new TypedField<>(String.class, "originalRel.issuer");
                TypedField<String> REMARK = new TypedField<>(String.class, "originalRel.remark");
                TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalRel.originalInvoiceNo");
                TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalRel.originalInvoiceCode");
                TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "originalRel.originalInvoiceType");
                TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "originalRel.originalDateIssued");
                TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "originalRel.redLetterNumber");
                TypedField<String> REVERSE_REASON = new TypedField<>(String.class, "originalRel.reverseReason");
                TypedField<String> NON_ISSUE_REASON = new TypedField<>(String.class, "originalRel.nonIssueReason");
                TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "originalRel.businessAttrs");
                TypedField<String> MESSAGE = new TypedField<>(String.class, "originalRel.message");
                TypedField<Long> ID = new TypedField<>(Long.class, "originalRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "originalRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "originalRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "originalRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "originalRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "originalRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "originalRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "originalRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "originalRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "originalRel.delete_flag");
                TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "originalRel.buyerBankName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "originalRel.buyerTaxNo");
                TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "originalRel.buyerAddress");
                TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "originalRel.buyerBankAccount");
                TypedField<String> BUYER_NO = new TypedField<>(String.class, "originalRel.buyerNo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "originalRel.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "originalRel.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "originalRel.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "originalRel.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "originalRel.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "originalRel.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "originalRel.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "originalRel.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "originalRel.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "originalRel.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "originalRel.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "originalRel.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "originalRel.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "originalRel.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "originalRel.ext15");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "originalRel.taxInvoiceSource");
                TypedField<String> BIZ_ORDER_ID = new TypedField<>(String.class, "originalRel.bizOrderId");
                TypedField<String> EXT16 = new TypedField<>(String.class, "originalRel.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "originalRel.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "originalRel.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "originalRel.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "originalRel.ext20");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "originalRel.buyerName");
                TypedField<String> BUYER_TEL = new TypedField<>(String.class, "originalRel.buyerTel");
                TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "originalRel.conversionStatus");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "originalRel.projectNo");
                TypedField<String> RULE_CONFIG = new TypedField<>(String.class, "originalRel.ruleConfig");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "originalRel.invoiceType");
                TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "originalRel.pricingMethod");
                TypedField<String> CUSTOMER_BIZ_ORDER_CATEGORY = new TypedField<>(String.class, "originalRel.customerBizOrderCategory");
                TypedField<BigDecimal> PRICE_ADJUSTMENT_RATIO = new TypedField<>(BigDecimal.class, "originalRel.priceAdjustmentRatio");
                TypedField<String> ORIGINAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "originalRel.originalAmountWithTax");
                TypedField<String> ORIGINAL_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "originalRel.originalAmountWithoutTax");
                TypedField<String> ORIGINAL_TAX_AMOUNT = new TypedField<>(String.class, "originalRel.originalTaxAmount");
                TypedField<String> ORIGINAL_TYPE = new TypedField<>(String.class, "originalRel.originalType");
                TypedField<String> ORIGINAL_BIZ_ORDER_NO = new TypedField<>(String.class, "originalRel.originalBizOrderNo");
                TypedField<String> EXCEPTION_MESSAGE = new TypedField<>(String.class, "originalRel.exceptionMessage");
            }
            interface BIZ_ORDER_AND_CAS_RELATIONSHIP {
                static String code () {
                    return "bizOrderAndCasRelationship" ;
                }
                TypedField<String> CAS_TAX_NO = new TypedField<>(String.class, "bizOrderAndCasRelationship.casTaxNo");
                TypedField<String> ENTERPRISE_NAME = new TypedField<>(String.class, "bizOrderAndCasRelationship.enterpriseName");
                TypedField<Long> ID = new TypedField<>(Long.class, "bizOrderAndCasRelationship.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "bizOrderAndCasRelationship.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "bizOrderAndCasRelationship.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "bizOrderAndCasRelationship.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "bizOrderAndCasRelationship.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "bizOrderAndCasRelationship.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "bizOrderAndCasRelationship.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "bizOrderAndCasRelationship.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "bizOrderAndCasRelationship.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "bizOrderAndCasRelationship.delete_flag");
            }
        }
    }
    public interface BizOrderOperateHistory {
        static Long id() {
            return 1736569323717136386L;
        }
        static String code() {
            return "bizOrderOperateHistory";
        }
        TypedField<String> TYPE = new TypedField<>(String.class, "type");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> CONTENT = new TypedField<>(String.class, "content");
        /**
         * 对一关联关系 关联对象 bizOrderInfo
         */
        TypedField<Long> HISTORY_BIZ_ORDER_REL_ID = new TypedField<>(Long.class, "historyBizOrderRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface HISTORY_BIZ_ORDER_REL {
                static String code () {
                    return "historyBizOrderRel" ;
                }
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "historyBizOrderRel.sellerName");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "historyBizOrderRel.sellerBankName");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "historyBizOrderRel.sellerTel");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "historyBizOrderRel.sellerNo");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "historyBizOrderRel.sellerAddress");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "historyBizOrderRel.sellerTaxNo");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "historyBizOrderRel.sellerBankAccount");
                TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "historyBizOrderRel.bizOrderNo");
                TypedField<String> RELATED_FLAG = new TypedField<>(String.class, "historyBizOrderRel.relatedFlag");
                TypedField<String> STATUS = new TypedField<>(String.class, "historyBizOrderRel.status");
                TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "historyBizOrderRel.sellerOrgCode");
                TypedField<String> BUYER_ORG_CODE = new TypedField<>(String.class, "historyBizOrderRel.buyerOrgCode");
                TypedField<String> BUYER_TYPE = new TypedField<>(String.class, "historyBizOrderRel.buyerType");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "historyBizOrderRel.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "historyBizOrderRel.amountWithoutTax");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "historyBizOrderRel.taxAmount");
                TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "historyBizOrderRel.outerDiscountWithTax");
                TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "historyBizOrderRel.outerDiscountWithoutTax");
                TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "historyBizOrderRel.innerDiscountWithTax");
                TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "historyBizOrderRel.innerDiscountWithoutTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "historyBizOrderRel.outerPrepayAmountWithTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "historyBizOrderRel.outerPrepayAmountWithoutTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "historyBizOrderRel.innerPrepayAmountWithTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "historyBizOrderRel.innerPrepayAmountWithoutTax");
                TypedField<String> REVIEWER = new TypedField<>(String.class, "historyBizOrderRel.reviewer");
                TypedField<String> PAYEE = new TypedField<>(String.class, "historyBizOrderRel.payee");
                TypedField<String> ISSUER = new TypedField<>(String.class, "historyBizOrderRel.issuer");
                TypedField<String> REMARK = new TypedField<>(String.class, "historyBizOrderRel.remark");
                TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "historyBizOrderRel.originalInvoiceNo");
                TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "historyBizOrderRel.originalInvoiceCode");
                TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "historyBizOrderRel.originalInvoiceType");
                TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "historyBizOrderRel.originalDateIssued");
                TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "historyBizOrderRel.redLetterNumber");
                TypedField<String> REVERSE_REASON = new TypedField<>(String.class, "historyBizOrderRel.reverseReason");
                TypedField<String> NON_ISSUE_REASON = new TypedField<>(String.class, "historyBizOrderRel.nonIssueReason");
                TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "historyBizOrderRel.businessAttrs");
                TypedField<String> MESSAGE = new TypedField<>(String.class, "historyBizOrderRel.message");
                TypedField<Long> ID = new TypedField<>(Long.class, "historyBizOrderRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "historyBizOrderRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "historyBizOrderRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "historyBizOrderRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "historyBizOrderRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "historyBizOrderRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "historyBizOrderRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "historyBizOrderRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "historyBizOrderRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "historyBizOrderRel.delete_flag");
                TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "historyBizOrderRel.buyerBankName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "historyBizOrderRel.buyerTaxNo");
                TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "historyBizOrderRel.buyerAddress");
                TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "historyBizOrderRel.buyerBankAccount");
                TypedField<String> BUYER_NO = new TypedField<>(String.class, "historyBizOrderRel.buyerNo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "historyBizOrderRel.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "historyBizOrderRel.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "historyBizOrderRel.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "historyBizOrderRel.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "historyBizOrderRel.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "historyBizOrderRel.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "historyBizOrderRel.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "historyBizOrderRel.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "historyBizOrderRel.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "historyBizOrderRel.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "historyBizOrderRel.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "historyBizOrderRel.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "historyBizOrderRel.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "historyBizOrderRel.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "historyBizOrderRel.ext15");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "historyBizOrderRel.taxInvoiceSource");
                TypedField<String> BIZ_ORDER_ID = new TypedField<>(String.class, "historyBizOrderRel.bizOrderId");
                TypedField<String> EXT16 = new TypedField<>(String.class, "historyBizOrderRel.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "historyBizOrderRel.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "historyBizOrderRel.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "historyBizOrderRel.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "historyBizOrderRel.ext20");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "historyBizOrderRel.buyerName");
                TypedField<String> BUYER_TEL = new TypedField<>(String.class, "historyBizOrderRel.buyerTel");
                TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "historyBizOrderRel.conversionStatus");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "historyBizOrderRel.projectNo");
                TypedField<String> RULE_CONFIG = new TypedField<>(String.class, "historyBizOrderRel.ruleConfig");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "historyBizOrderRel.invoiceType");
                TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "historyBizOrderRel.pricingMethod");
                TypedField<String> CUSTOMER_BIZ_ORDER_CATEGORY = new TypedField<>(String.class, "historyBizOrderRel.customerBizOrderCategory");
                TypedField<BigDecimal> PRICE_ADJUSTMENT_RATIO = new TypedField<>(BigDecimal.class, "historyBizOrderRel.priceAdjustmentRatio");
                TypedField<String> ORIGINAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "historyBizOrderRel.originalAmountWithTax");
                TypedField<String> ORIGINAL_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "historyBizOrderRel.originalAmountWithoutTax");
                TypedField<String> ORIGINAL_TAX_AMOUNT = new TypedField<>(String.class, "historyBizOrderRel.originalTaxAmount");
                TypedField<String> ORIGINAL_TYPE = new TypedField<>(String.class, "historyBizOrderRel.originalType");
                TypedField<String> ORIGINAL_BIZ_ORDER_NO = new TypedField<>(String.class, "historyBizOrderRel.originalBizOrderNo");
                TypedField<String> EXCEPTION_MESSAGE = new TypedField<>(String.class, "historyBizOrderRel.exceptionMessage");
            }
        }
    }
    public interface BizOrderDetail {
        static Long id() {
            return 1736714217132249090L;
        }
        static String code() {
            return "bizOrderDetail";
        }
        TypedField<String> BIZ_ORDER_DETAIL_NO = new TypedField<>(String.class, "bizOrderDetailNo");
        TypedField<String> DETAIL_CATEGORY = new TypedField<>(String.class, "detailCategory");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> SPECIFICATIONS = new TypedField<>(String.class, "specifications");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "itemShortName");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unitPrice");
        TypedField<String> CHECK_UNIT_PRICE = new TypedField<>(String.class, "checkUnitPrice");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> DEDUCTION = new TypedField<>(String.class, "deduction");
        TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "outerDiscountWithTax");
        TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "outerDiscountWithoutTax");
        TypedField<String> OUTER_DISCOUNT_TAX = new TypedField<>(String.class, "outerDiscountTax");
        TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "innerDiscountWithTax");
        TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "innerDiscountWithoutTax");
        TypedField<String> INNER_DISCOUNT_TAX = new TypedField<>(String.class, "innerDiscountTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "outerPrepayAmountWithTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "outerPrepayAmountWithoutTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_TAX = new TypedField<>(String.class, "outerPrepayAmountTax");
        TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "innerPrepayAmountWithTax");
        TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "innerPrepayAmountWithoutTax");
        TypedField<String> INNER_PREPAY_AMOUNT_TAX = new TypedField<>(String.class, "innerPrepayAmountTax");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> GOODS_TAX_NO_VERSION = new TypedField<>(String.class, "goodsTaxNoVersion");
        TypedField<String> TAX_CONVERT_CODE = new TypedField<>(String.class, "taxConvertCode");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "businessAttrs");
        TypedField<String> ITEM_TYPE_CODE = new TypedField<>(String.class, "itemTypeCode");
        TypedField<String> SPECIAL_ADDITIONS = new TypedField<>(String.class, "specialAdditions");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<BigDecimal> PRICE_ADJUSTMENT_RATIO = new TypedField<>(BigDecimal.class, "priceAdjustmentRatio");
        TypedField<BigDecimal> PRICE_ADJUSTMENT_RATIO_TO = new TypedField<>(BigDecimal.class, "priceAdjustmentRatioTo");
        TypedField<String> UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "unitPriceWithTax");
        TypedField<String> ORIGINAL_UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "originalUnitPriceWithTax");
        TypedField<String> ORIGINAL_UNIT_PRICE = new TypedField<>(String.class, "originalUnitPrice");
        TypedField<String> ORIGINAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "originalAmountWithTax");
        TypedField<String> ORIGINAL_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "originalAmountWithoutTax");
        TypedField<String> ORIGINAL_TAX_AMOUNT = new TypedField<>(String.class, "originalTaxAmount");
        /**
         * 对一关联关系 关联对象 bizOrderInfo
         */
        TypedField<Long> BIZ_ORDER_REL_ID = new TypedField<>(Long.class, "bizOrderRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BIZ_ORDER_REL {
                static String code () {
                    return "bizOrderRel" ;
                }
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "bizOrderRel.sellerName");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "bizOrderRel.sellerBankName");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "bizOrderRel.sellerTel");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "bizOrderRel.sellerNo");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "bizOrderRel.sellerAddress");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "bizOrderRel.sellerTaxNo");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "bizOrderRel.sellerBankAccount");
                TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "bizOrderRel.bizOrderNo");
                TypedField<String> RELATED_FLAG = new TypedField<>(String.class, "bizOrderRel.relatedFlag");
                TypedField<String> STATUS = new TypedField<>(String.class, "bizOrderRel.status");
                TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "bizOrderRel.sellerOrgCode");
                TypedField<String> BUYER_ORG_CODE = new TypedField<>(String.class, "bizOrderRel.buyerOrgCode");
                TypedField<String> BUYER_TYPE = new TypedField<>(String.class, "bizOrderRel.buyerType");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderRel.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderRel.amountWithoutTax");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "bizOrderRel.taxAmount");
                TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderRel.outerDiscountWithTax");
                TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderRel.outerDiscountWithoutTax");
                TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderRel.innerDiscountWithTax");
                TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderRel.innerDiscountWithoutTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderRel.outerPrepayAmountWithTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderRel.outerPrepayAmountWithoutTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderRel.innerPrepayAmountWithTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderRel.innerPrepayAmountWithoutTax");
                TypedField<String> REVIEWER = new TypedField<>(String.class, "bizOrderRel.reviewer");
                TypedField<String> PAYEE = new TypedField<>(String.class, "bizOrderRel.payee");
                TypedField<String> ISSUER = new TypedField<>(String.class, "bizOrderRel.issuer");
                TypedField<String> REMARK = new TypedField<>(String.class, "bizOrderRel.remark");
                TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "bizOrderRel.originalInvoiceNo");
                TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "bizOrderRel.originalInvoiceCode");
                TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "bizOrderRel.originalInvoiceType");
                TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "bizOrderRel.originalDateIssued");
                TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "bizOrderRel.redLetterNumber");
                TypedField<String> REVERSE_REASON = new TypedField<>(String.class, "bizOrderRel.reverseReason");
                TypedField<String> NON_ISSUE_REASON = new TypedField<>(String.class, "bizOrderRel.nonIssueReason");
                TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "bizOrderRel.businessAttrs");
                TypedField<String> MESSAGE = new TypedField<>(String.class, "bizOrderRel.message");
                TypedField<Long> ID = new TypedField<>(Long.class, "bizOrderRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "bizOrderRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "bizOrderRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "bizOrderRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "bizOrderRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "bizOrderRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "bizOrderRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "bizOrderRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "bizOrderRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "bizOrderRel.delete_flag");
                TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "bizOrderRel.buyerBankName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "bizOrderRel.buyerTaxNo");
                TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "bizOrderRel.buyerAddress");
                TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "bizOrderRel.buyerBankAccount");
                TypedField<String> BUYER_NO = new TypedField<>(String.class, "bizOrderRel.buyerNo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "bizOrderRel.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "bizOrderRel.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "bizOrderRel.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "bizOrderRel.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "bizOrderRel.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "bizOrderRel.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "bizOrderRel.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "bizOrderRel.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "bizOrderRel.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "bizOrderRel.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "bizOrderRel.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "bizOrderRel.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "bizOrderRel.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "bizOrderRel.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "bizOrderRel.ext15");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "bizOrderRel.taxInvoiceSource");
                TypedField<String> BIZ_ORDER_ID = new TypedField<>(String.class, "bizOrderRel.bizOrderId");
                TypedField<String> EXT16 = new TypedField<>(String.class, "bizOrderRel.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "bizOrderRel.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "bizOrderRel.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "bizOrderRel.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "bizOrderRel.ext20");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "bizOrderRel.buyerName");
                TypedField<String> BUYER_TEL = new TypedField<>(String.class, "bizOrderRel.buyerTel");
                TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "bizOrderRel.conversionStatus");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "bizOrderRel.projectNo");
                TypedField<String> RULE_CONFIG = new TypedField<>(String.class, "bizOrderRel.ruleConfig");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "bizOrderRel.invoiceType");
                TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "bizOrderRel.pricingMethod");
                TypedField<String> CUSTOMER_BIZ_ORDER_CATEGORY = new TypedField<>(String.class, "bizOrderRel.customerBizOrderCategory");
                TypedField<BigDecimal> PRICE_ADJUSTMENT_RATIO = new TypedField<>(BigDecimal.class, "bizOrderRel.priceAdjustmentRatio");
                TypedField<String> ORIGINAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderRel.originalAmountWithTax");
                TypedField<String> ORIGINAL_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderRel.originalAmountWithoutTax");
                TypedField<String> ORIGINAL_TAX_AMOUNT = new TypedField<>(String.class, "bizOrderRel.originalTaxAmount");
                TypedField<String> ORIGINAL_TYPE = new TypedField<>(String.class, "bizOrderRel.originalType");
                TypedField<String> ORIGINAL_BIZ_ORDER_NO = new TypedField<>(String.class, "bizOrderRel.originalBizOrderNo");
                TypedField<String> EXCEPTION_MESSAGE = new TypedField<>(String.class, "bizOrderRel.exceptionMessage");
            }
        }
    }
    public interface PurchaseInvoiceBaseInfo {
        static Long id() {
            return 1737439624775659521L;
        }
        static String code() {
            return "purchaseInvoiceBaseInfo";
        }
        TypedField<LocalDateTime> LAST_UPDATE_TIME = new TypedField<>(LocalDateTime.class, "lastUpdateTime");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> ENTRY_STATUS = new TypedField<>(String.class, "entryStatus");
        TypedField<String> VERIFY_STATUS = new TypedField<>(String.class, "verifyStatus");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "allElectricInvoiceNo");
        TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "bizOrderNo");
        /**
         * 对一关联关系 关联对象 bizOrderOriginalInfo
         */
        TypedField<Long> BIZ_ORIGINAL_ORDER_INVOICE_REL_ID = new TypedField<>(Long.class, "bizOriginalOrderInvoiceRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BIZ_ORIGINAL_ORDER_INVOICE_REL {
                static String code () {
                    return "bizOriginalOrderInvoiceRel" ;
                }
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.sellerName");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.sellerBankName");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.sellerTel");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.sellerNo");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.sellerAddress");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.sellerTaxNo");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.sellerBankAccount");
                TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.bizOrderNo");
                TypedField<String> RELATED_FLAG = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.relatedFlag");
                TypedField<String> STATUS = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.status");
                TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.sellerOrgCode");
                TypedField<String> BUYER_ORG_CODE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.buyerOrgCode");
                TypedField<String> BUYER_TYPE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.buyerType");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.amountWithoutTax");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.taxAmount");
                TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.outerDiscountWithTax");
                TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.outerDiscountWithoutTax");
                TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.innerDiscountWithTax");
                TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.innerDiscountWithoutTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.outerPrepayAmountWithTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.outerPrepayAmountWithoutTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.innerPrepayAmountWithTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.innerPrepayAmountWithoutTax");
                TypedField<String> REVIEWER = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.reviewer");
                TypedField<String> PAYEE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.payee");
                TypedField<String> ISSUER = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.issuer");
                TypedField<String> REMARK = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.remark");
                TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.originalInvoiceNo");
                TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.originalInvoiceCode");
                TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.originalInvoiceType");
                TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.originalDateIssued");
                TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.redLetterNumber");
                TypedField<String> REVERSE_REASON = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.reverseReason");
                TypedField<String> NON_ISSUE_REASON = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.nonIssueReason");
                TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.businessAttrs");
                TypedField<String> MESSAGE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.message");
                TypedField<Long> ID = new TypedField<>(Long.class, "bizOriginalOrderInvoiceRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "bizOriginalOrderInvoiceRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "bizOriginalOrderInvoiceRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "bizOriginalOrderInvoiceRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "bizOriginalOrderInvoiceRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "bizOriginalOrderInvoiceRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.delete_flag");
                TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.buyerBankName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.buyerTaxNo");
                TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.buyerAddress");
                TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.buyerBankAccount");
                TypedField<String> BUYER_NO = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.buyerNo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext15");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.taxInvoiceSource");
                TypedField<String> BIZ_ORDER_ID = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.bizOrderId");
                TypedField<String> EXT16 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ext20");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.buyerName");
                TypedField<String> BUYER_TEL = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.buyerTel");
                TypedField<Boolean> CREATE_PURCHASE_RE_SALE_BIZ_ORDER_FLAG = new TypedField<>(Boolean.class, "bizOriginalOrderInvoiceRel.createPurchaseReSaleBizOrderFlag");
                TypedField<String> RULE_CONFIG = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.ruleConfig");
                TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.pricingMethod");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.invoiceType");
                TypedField<String> CUSTOMER_BIZ_ORDER_CATEGORY = new TypedField<>(String.class, "bizOriginalOrderInvoiceRel.customerBizOrderCategory");
            }
        }
    }
    public interface SaleInvoiceBaseInfo {
        static Long id() {
            return 1737649089119522817L;
        }
        static String code() {
            return "saleInvoiceBaseInfo";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoiceCode");
        TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "bizOrderNo");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoiceNo");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> DATE_ISSUED = new TypedField<>(String.class, "dateIssued");
        TypedField<String> ALL_ELECTRIC_INVOICE_NO = new TypedField<>(String.class, "allElectricInvoiceNo");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> INVOICE_COLOR = new TypedField<>(String.class, "invoiceColor");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "originInvoiceNo");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "originInvoiceCode");
        TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "originInvoiceType");
        /**
         * 对一关联关系 关联对象 bizOrderInfo
         */
        TypedField<Long> SALE_INVOICE_BIZ_ORDER_REL_ID = new TypedField<>(Long.class, "saleInvoiceBizOrderRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface SALE_INVOICE_BIZ_ORDER_REL {
                static String code () {
                    return "saleInvoiceBizOrderRel" ;
                }
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "saleInvoiceBizOrderRel.sellerName");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "saleInvoiceBizOrderRel.sellerBankName");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "saleInvoiceBizOrderRel.sellerTel");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "saleInvoiceBizOrderRel.sellerNo");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "saleInvoiceBizOrderRel.sellerAddress");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "saleInvoiceBizOrderRel.sellerTaxNo");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "saleInvoiceBizOrderRel.sellerBankAccount");
                TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "saleInvoiceBizOrderRel.bizOrderNo");
                TypedField<String> RELATED_FLAG = new TypedField<>(String.class, "saleInvoiceBizOrderRel.relatedFlag");
                TypedField<String> STATUS = new TypedField<>(String.class, "saleInvoiceBizOrderRel.status");
                TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.sellerOrgCode");
                TypedField<String> BUYER_ORG_CODE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.buyerOrgCode");
                TypedField<String> BUYER_TYPE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.buyerType");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.amountWithoutTax");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "saleInvoiceBizOrderRel.taxAmount");
                TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.outerDiscountWithTax");
                TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.outerDiscountWithoutTax");
                TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.innerDiscountWithTax");
                TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.innerDiscountWithoutTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.outerPrepayAmountWithTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.outerPrepayAmountWithoutTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.innerPrepayAmountWithTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.innerPrepayAmountWithoutTax");
                TypedField<String> REVIEWER = new TypedField<>(String.class, "saleInvoiceBizOrderRel.reviewer");
                TypedField<String> PAYEE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.payee");
                TypedField<String> ISSUER = new TypedField<>(String.class, "saleInvoiceBizOrderRel.issuer");
                TypedField<String> REMARK = new TypedField<>(String.class, "saleInvoiceBizOrderRel.remark");
                TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "saleInvoiceBizOrderRel.originalInvoiceNo");
                TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.originalInvoiceCode");
                TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.originalInvoiceType");
                TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "saleInvoiceBizOrderRel.originalDateIssued");
                TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "saleInvoiceBizOrderRel.redLetterNumber");
                TypedField<String> REVERSE_REASON = new TypedField<>(String.class, "saleInvoiceBizOrderRel.reverseReason");
                TypedField<String> NON_ISSUE_REASON = new TypedField<>(String.class, "saleInvoiceBizOrderRel.nonIssueReason");
                TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "saleInvoiceBizOrderRel.businessAttrs");
                TypedField<String> MESSAGE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.message");
                TypedField<Long> ID = new TypedField<>(Long.class, "saleInvoiceBizOrderRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "saleInvoiceBizOrderRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "saleInvoiceBizOrderRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "saleInvoiceBizOrderRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "saleInvoiceBizOrderRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "saleInvoiceBizOrderRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "saleInvoiceBizOrderRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "saleInvoiceBizOrderRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "saleInvoiceBizOrderRel.delete_flag");
                TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "saleInvoiceBizOrderRel.buyerBankName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "saleInvoiceBizOrderRel.buyerTaxNo");
                TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "saleInvoiceBizOrderRel.buyerAddress");
                TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "saleInvoiceBizOrderRel.buyerBankAccount");
                TypedField<String> BUYER_NO = new TypedField<>(String.class, "saleInvoiceBizOrderRel.buyerNo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext15");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.taxInvoiceSource");
                TypedField<String> BIZ_ORDER_ID = new TypedField<>(String.class, "saleInvoiceBizOrderRel.bizOrderId");
                TypedField<String> EXT16 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ext20");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "saleInvoiceBizOrderRel.buyerName");
                TypedField<String> BUYER_TEL = new TypedField<>(String.class, "saleInvoiceBizOrderRel.buyerTel");
                TypedField<String> CONVERSION_STATUS = new TypedField<>(String.class, "saleInvoiceBizOrderRel.conversionStatus");
                TypedField<String> PROJECT_NO = new TypedField<>(String.class, "saleInvoiceBizOrderRel.projectNo");
                TypedField<String> RULE_CONFIG = new TypedField<>(String.class, "saleInvoiceBizOrderRel.ruleConfig");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.invoiceType");
                TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "saleInvoiceBizOrderRel.pricingMethod");
                TypedField<String> CUSTOMER_BIZ_ORDER_CATEGORY = new TypedField<>(String.class, "saleInvoiceBizOrderRel.customerBizOrderCategory");
                TypedField<BigDecimal> PRICE_ADJUSTMENT_RATIO = new TypedField<>(BigDecimal.class, "saleInvoiceBizOrderRel.priceAdjustmentRatio");
                TypedField<String> ORIGINAL_AMOUNT_WITH_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.originalAmountWithTax");
                TypedField<String> ORIGINAL_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "saleInvoiceBizOrderRel.originalAmountWithoutTax");
                TypedField<String> ORIGINAL_TAX_AMOUNT = new TypedField<>(String.class, "saleInvoiceBizOrderRel.originalTaxAmount");
                TypedField<String> ORIGINAL_TYPE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.originalType");
                TypedField<String> ORIGINAL_BIZ_ORDER_NO = new TypedField<>(String.class, "saleInvoiceBizOrderRel.originalBizOrderNo");
                TypedField<String> EXCEPTION_MESSAGE = new TypedField<>(String.class, "saleInvoiceBizOrderRel.exceptionMessage");
            }
        }
    }
    public interface BizOrderOriginalInfo {
        static Long id() {
            return 1737649590878924802L;
        }
        static String code() {
            return "bizOrderOriginalInfo";
        }
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "sellerName");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "sellerBankName");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "sellerTel");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "sellerNo");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "sellerAddress");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "sellerTaxNo");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "sellerBankAccount");
        TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "bizOrderNo");
        TypedField<String> RELATED_FLAG = new TypedField<>(String.class, "relatedFlag");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "sellerOrgCode");
        TypedField<String> BUYER_ORG_CODE = new TypedField<>(String.class, "buyerOrgCode");
        TypedField<String> BUYER_TYPE = new TypedField<>(String.class, "buyerType");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "outerDiscountWithTax");
        TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "outerDiscountWithoutTax");
        TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "innerDiscountWithTax");
        TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "innerDiscountWithoutTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "outerPrepayAmountWithTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "outerPrepayAmountWithoutTax");
        TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "innerPrepayAmountWithTax");
        TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "innerPrepayAmountWithoutTax");
        TypedField<String> REVIEWER = new TypedField<>(String.class, "reviewer");
        TypedField<String> PAYEE = new TypedField<>(String.class, "payee");
        TypedField<String> ISSUER = new TypedField<>(String.class, "issuer");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "originalInvoiceNo");
        TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "originalInvoiceCode");
        TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "originalInvoiceType");
        TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "originalDateIssued");
        TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "redLetterNumber");
        TypedField<String> REVERSE_REASON = new TypedField<>(String.class, "reverseReason");
        TypedField<String> NON_ISSUE_REASON = new TypedField<>(String.class, "nonIssueReason");
        TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "businessAttrs");
        TypedField<String> MESSAGE = new TypedField<>(String.class, "message");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "buyerBankName");
        TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "buyerTaxNo");
        TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "buyerAddress");
        TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "buyerBankAccount");
        TypedField<String> BUYER_NO = new TypedField<>(String.class, "buyerNo");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "taxInvoiceSource");
        TypedField<String> BIZ_ORDER_ID = new TypedField<>(String.class, "bizOrderId");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> BUYER_NAME = new TypedField<>(String.class, "buyerName");
        TypedField<String> BUYER_TEL = new TypedField<>(String.class, "buyerTel");
        TypedField<Boolean> CREATE_PURCHASE_RE_SALE_BIZ_ORDER_FLAG = new TypedField<>(Boolean.class, "createPurchaseReSaleBizOrderFlag");
        TypedField<String> RULE_CONFIG = new TypedField<>(String.class, "ruleConfig");
        TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "pricingMethod");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoiceType");
        TypedField<String> CUSTOMER_BIZ_ORDER_CATEGORY = new TypedField<>(String.class, "customerBizOrderCategory");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
        }
    }
    public interface BizOrderOriginalDetail {
        static Long id() {
            return 1737649846863630337L;
        }
        static String code() {
            return "bizOrderOriginalDetail";
        }
        TypedField<String> BIZ_ORDER_DETAIL_NO = new TypedField<>(String.class, "bizOrderDetailNo");
        TypedField<String> DETAIL_CATEGORY = new TypedField<>(String.class, "detailCategory");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "itemCode");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "itemName");
        TypedField<String> SPECIFICATIONS = new TypedField<>(String.class, "specifications");
        TypedField<String> UNIT = new TypedField<>(String.class, "unit");
        TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "itemShortName");
        TypedField<String> QUANTITY = new TypedField<>(String.class, "quantity");
        TypedField<String> UNIT_PRICE = new TypedField<>(String.class, "unitPrice");
        TypedField<String> CHECK_UNIT_PRICE = new TypedField<>(String.class, "checkUnitPrice");
        TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "amountWithTax");
        TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "amountWithoutTax");
        TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "taxAmount");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "taxRate");
        TypedField<String> DEDUCTION = new TypedField<>(String.class, "deduction");
        TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "outerDiscountWithTax");
        TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "outerDiscountWithoutTax");
        TypedField<String> OUTER_DISCOUNT_TAX = new TypedField<>(String.class, "outerDiscountTax");
        TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "innerDiscountWithTax");
        TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "innerDiscountWithoutTax");
        TypedField<String> INNER_DISCOUNT_TAX = new TypedField<>(String.class, "innerDiscountTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "outerPrepayAmountWithTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "outerPrepayAmountWithoutTax");
        TypedField<String> OUTER_PREPAY_AMOUNT_TAX = new TypedField<>(String.class, "outerPrepayAmountTax");
        TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "innerPrepayAmountWithTax");
        TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "innerPrepayAmountWithoutTax");
        TypedField<String> INNER_PREPAY_AMOUNT_TAX = new TypedField<>(String.class, "innerPrepayAmountTax");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goodsTaxNo");
        TypedField<String> GOODS_TAX_NO_VERSION = new TypedField<>(String.class, "goodsTaxNoVersion");
        TypedField<String> TAX_CONVERT_CODE = new TypedField<>(String.class, "taxConvertCode");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "taxPre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "taxPreCon");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zeroTax");
        TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "businessAttrs");
        TypedField<String> ITEM_TYPE_CODE = new TypedField<>(String.class, "itemTypeCode");
        TypedField<String> SPECIAL_ADDITIONS = new TypedField<>(String.class, "specialAdditions");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> UNIT_PRICE_WITH_TAX = new TypedField<>(String.class, "unitPriceWithTax");
        /**
         * 对一关联关系 关联对象 bizOrderOriginalInfo
         */
        TypedField<Long> BIZ_ORDER_ORIGINAL_REL_ID = new TypedField<>(Long.class, "bizOrderOriginalRel.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BIZ_ORDER_ORIGINAL_REL {
                static String code () {
                    return "bizOrderOriginalRel" ;
                }
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "bizOrderOriginalRel.sellerName");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "bizOrderOriginalRel.sellerBankName");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "bizOrderOriginalRel.sellerTel");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "bizOrderOriginalRel.sellerNo");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "bizOrderOriginalRel.sellerAddress");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "bizOrderOriginalRel.sellerTaxNo");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "bizOrderOriginalRel.sellerBankAccount");
                TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "bizOrderOriginalRel.bizOrderNo");
                TypedField<String> RELATED_FLAG = new TypedField<>(String.class, "bizOrderOriginalRel.relatedFlag");
                TypedField<String> STATUS = new TypedField<>(String.class, "bizOrderOriginalRel.status");
                TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "bizOrderOriginalRel.sellerOrgCode");
                TypedField<String> BUYER_ORG_CODE = new TypedField<>(String.class, "bizOrderOriginalRel.buyerOrgCode");
                TypedField<String> BUYER_TYPE = new TypedField<>(String.class, "bizOrderOriginalRel.buyerType");
                TypedField<String> AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.amountWithTax");
                TypedField<String> AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.amountWithoutTax");
                TypedField<String> TAX_AMOUNT = new TypedField<>(String.class, "bizOrderOriginalRel.taxAmount");
                TypedField<String> OUTER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.outerDiscountWithTax");
                TypedField<String> OUTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.outerDiscountWithoutTax");
                TypedField<String> INNER_DISCOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.innerDiscountWithTax");
                TypedField<String> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.innerDiscountWithoutTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.outerPrepayAmountWithTax");
                TypedField<String> OUTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.outerPrepayAmountWithoutTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.innerPrepayAmountWithTax");
                TypedField<String> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(String.class, "bizOrderOriginalRel.innerPrepayAmountWithoutTax");
                TypedField<String> REVIEWER = new TypedField<>(String.class, "bizOrderOriginalRel.reviewer");
                TypedField<String> PAYEE = new TypedField<>(String.class, "bizOrderOriginalRel.payee");
                TypedField<String> ISSUER = new TypedField<>(String.class, "bizOrderOriginalRel.issuer");
                TypedField<String> REMARK = new TypedField<>(String.class, "bizOrderOriginalRel.remark");
                TypedField<String> ORIGINAL_INVOICE_NO = new TypedField<>(String.class, "bizOrderOriginalRel.originalInvoiceNo");
                TypedField<String> ORIGINAL_INVOICE_CODE = new TypedField<>(String.class, "bizOrderOriginalRel.originalInvoiceCode");
                TypedField<String> ORIGINAL_INVOICE_TYPE = new TypedField<>(String.class, "bizOrderOriginalRel.originalInvoiceType");
                TypedField<String> ORIGINAL_DATE_ISSUED = new TypedField<>(String.class, "bizOrderOriginalRel.originalDateIssued");
                TypedField<String> RED_LETTER_NUMBER = new TypedField<>(String.class, "bizOrderOriginalRel.redLetterNumber");
                TypedField<String> REVERSE_REASON = new TypedField<>(String.class, "bizOrderOriginalRel.reverseReason");
                TypedField<String> NON_ISSUE_REASON = new TypedField<>(String.class, "bizOrderOriginalRel.nonIssueReason");
                TypedField<String> BUSINESS_ATTRS = new TypedField<>(String.class, "bizOrderOriginalRel.businessAttrs");
                TypedField<String> MESSAGE = new TypedField<>(String.class, "bizOrderOriginalRel.message");
                TypedField<Long> ID = new TypedField<>(Long.class, "bizOrderOriginalRel.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "bizOrderOriginalRel.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "bizOrderOriginalRel.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "bizOrderOriginalRel.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "bizOrderOriginalRel.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "bizOrderOriginalRel.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "bizOrderOriginalRel.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "bizOrderOriginalRel.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "bizOrderOriginalRel.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "bizOrderOriginalRel.delete_flag");
                TypedField<String> BUYER_BANK_NAME = new TypedField<>(String.class, "bizOrderOriginalRel.buyerBankName");
                TypedField<String> BUYER_TAX_NO = new TypedField<>(String.class, "bizOrderOriginalRel.buyerTaxNo");
                TypedField<String> BUYER_ADDRESS = new TypedField<>(String.class, "bizOrderOriginalRel.buyerAddress");
                TypedField<String> BUYER_BANK_ACCOUNT = new TypedField<>(String.class, "bizOrderOriginalRel.buyerBankAccount");
                TypedField<String> BUYER_NO = new TypedField<>(String.class, "bizOrderOriginalRel.buyerNo");
                TypedField<String> EXT1 = new TypedField<>(String.class, "bizOrderOriginalRel.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "bizOrderOriginalRel.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "bizOrderOriginalRel.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "bizOrderOriginalRel.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "bizOrderOriginalRel.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "bizOrderOriginalRel.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "bizOrderOriginalRel.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "bizOrderOriginalRel.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "bizOrderOriginalRel.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "bizOrderOriginalRel.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "bizOrderOriginalRel.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "bizOrderOriginalRel.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "bizOrderOriginalRel.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "bizOrderOriginalRel.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "bizOrderOriginalRel.ext15");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "bizOrderOriginalRel.taxInvoiceSource");
                TypedField<String> BIZ_ORDER_ID = new TypedField<>(String.class, "bizOrderOriginalRel.bizOrderId");
                TypedField<String> EXT16 = new TypedField<>(String.class, "bizOrderOriginalRel.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "bizOrderOriginalRel.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "bizOrderOriginalRel.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "bizOrderOriginalRel.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "bizOrderOriginalRel.ext20");
                TypedField<String> BUYER_NAME = new TypedField<>(String.class, "bizOrderOriginalRel.buyerName");
                TypedField<String> BUYER_TEL = new TypedField<>(String.class, "bizOrderOriginalRel.buyerTel");
                TypedField<Boolean> CREATE_PURCHASE_RE_SALE_BIZ_ORDER_FLAG = new TypedField<>(Boolean.class, "bizOrderOriginalRel.createPurchaseReSaleBizOrderFlag");
                TypedField<String> RULE_CONFIG = new TypedField<>(String.class, "bizOrderOriginalRel.ruleConfig");
                TypedField<String> PRICING_METHOD = new TypedField<>(String.class, "bizOrderOriginalRel.pricingMethod");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "bizOrderOriginalRel.invoiceType");
                TypedField<String> CUSTOMER_BIZ_ORDER_CATEGORY = new TypedField<>(String.class, "bizOrderOriginalRel.customerBizOrderCategory");
            }
        }
    }
    public interface CasInfo {
        static Long id() {
            return 1810209223745736705L;
        }
        static String code() {
            return "casInfo";
        }
        TypedField<String> CAS_TAX_NO = new TypedField<>(String.class, "casTaxNo");
        TypedField<String> ENTERPRISE_NAME = new TypedField<>(String.class, "enterpriseName");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
    }
    public interface BizOrder {
        static Long id() {
            return 1810580892354686978L;
        }
        static String code() {
            return "bizOrder";
        }
        TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "biz_order_no");
        TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "cooperate_flag");
        TypedField<String> WAYBILL_NUMBER = new TypedField<>(String.class, "waybill_number");
        TypedField<LocalDateTime> BILL_SIGN_TIME = new TypedField<>(LocalDateTime.class, "bill_sign_time");
        TypedField<String> BILL_SIGN_USER_NAME = new TypedField<>(String.class, "bill_sign_user_name");
        TypedField<String> IS_QUALIFIED = new TypedField<>(String.class, "is_qualified");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> ORIGIN_BIZ_ORDER_NO = new TypedField<>(String.class, "origin_biz_order_no");
        TypedField<String> SELLER_NO = new TypedField<>(String.class, "seller_no");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> SELLER_TEL = new TypedField<>(String.class, "seller_tel");
        TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "seller_address");
        TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "seller_bank_name");
        TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "seller_bank_account");
        TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "seller_tenant_id");
        TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "seller_id");
        TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "purchaser_no");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "purchaser_tel");
        TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "purchaser_address");
        TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "purchaser_bank_name");
        TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "purchaser_id");
        TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "business_bill_type");
        TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "tax_invoice_source");
        TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "system_orig");
        TypedField<String> BIZ_ORDER_TYPE = new TypedField<>(String.class, "biz_order_type");
        TypedField<String> RECEIPT_TYPE = new TypedField<>(String.class, "receipt_type");
        TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "price_method");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> ORIGIN_AMOUNT = new TypedField<>(BigDecimal.class, "origin_amount");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_with_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "already_make_amount_without_tax");
        TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "already_make_amount_tax_amount");
        TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "abandon_freeze_amount_with_tax");
        TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "abandon_freeze_amount_without_tax");
        TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "abandon_freeze_amount_tax_amount");
        TypedField<BigDecimal> DISCOUNT_WITH_TAX_TOTAL = new TypedField<>(BigDecimal.class, "discount_with_tax_total");
        TypedField<BigDecimal> DISCOUNT_WITHOUT_TAX_TOTAL = new TypedField<>(BigDecimal.class, "discount_without_tax_total");
        TypedField<BigDecimal> DISCOUNT_TAX_AMOUNT_TOTAL = new TypedField<>(BigDecimal.class, "discount_tax_amount_total");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "outter_discount_with_tax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "outter_discount_without_tax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "inner_discount_with_tax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "inner_discount_without_tax");
        TypedField<BigDecimal> OUTTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "outter_prepay_amount_with_tax");
        TypedField<BigDecimal> OUTTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "outter_prepay_amount_without_tax");
        TypedField<BigDecimal> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "inner_prepay_amount_with_tax");
        TypedField<BigDecimal> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "inner_prepay_amount_without_tax");
        TypedField<String> UPLOAD_CONFIRM_FLAG = new TypedField<>(String.class, "upload_confirm_flag");
        TypedField<String> RECEIVE_CONFIRM_FLAG = new TypedField<>(String.class, "receive_confirm_flag");
        TypedField<String> MAKEOUT_STATUS = new TypedField<>(String.class, "makeout_status");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> MODIFY_MARK = new TypedField<>(Long.class, "modify_mark");
        TypedField<String> COOPERATE_MODIFY_STATUS = new TypedField<>(String.class, "cooperate_modify_status");
        TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "origin_invoice_no");
        TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "origin_invoice_code");
        TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "origin_invoice_type");
        TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "origin_paper_draw_date");
        TypedField<String> RED_NOTIFICATION = new TypedField<>(String.class, "red_notification");
        TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "checker_name");
        TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "cashier_name");
        TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "invoicer_name");
        TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "receive_user_email");
        TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "receive_user_tel");
        TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "sys_org_id");
        TypedField<String> USING_STATUS = new TypedField<>(String.class, "using_status");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customer_no");
        TypedField<String> ADDRESSEE = new TypedField<>(String.class, "addressee");
        TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "addressee_tel");
        TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "addressee_province");
        TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "addressee_city");
        TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "addressee_county");
        TypedField<String> DIRECTION = new TypedField<>(String.class, "direction");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "logistic_remark");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> EXT21 = new TypedField<>(String.class, "ext21");
        TypedField<String> EXT22 = new TypedField<>(String.class, "ext22");
        TypedField<String> EXT23 = new TypedField<>(String.class, "ext23");
        TypedField<String> EXT24 = new TypedField<>(String.class, "ext24");
        TypedField<String> EXT25 = new TypedField<>(String.class, "ext25");
        TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "audit_status");
        TypedField<String> SYSTEM_ORIG_TYPE = new TypedField<>(String.class, "system_orig_type");
        TypedField<String> APPLY_INVALID_FLAG = new TypedField<>(String.class, "apply_invalid_flag");
        TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "match_status");
        TypedField<String> MAKING_REASON = new TypedField<>(String.class, "making_reason");
        TypedField<String> IMPORT_BATCH_NO = new TypedField<>(String.class, "import_batch_no");
        TypedField<String> POS_DATE = new TypedField<>(String.class, "pos_date");
        TypedField<Long> CHANNEL = new TypedField<>(Long.class, "channel");
        TypedField<String> PROCESS_REMARK = new TypedField<>(String.class, "process_remark");
        TypedField<String> PURCHASER_TYPE = new TypedField<>(String.class, "purchaser_type");
        TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "audit_time");
        TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "auth_status");
        TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "check_time");
        TypedField<LocalDateTime> AUTH_TIME = new TypedField<>(LocalDateTime.class, "auth_time");
        TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "recog_status");
        TypedField<LocalDateTime> RECOG_TIME = new TypedField<>(LocalDateTime.class, "recog_time");
        TypedField<String> IS_NEED_AUTH = new TypedField<>(String.class, "is_need_auth");
        TypedField<BigDecimal> EFFECTIVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "effective_tax_amount");
        TypedField<String> EXCEPTION_TYPE = new TypedField<>(String.class, "exception_type");
        TypedField<String> EXCEPTION_REMARK = new TypedField<>(String.class, "exception_remark");
        TypedField<LocalDateTime> PARCEL_SIGN_TIME = new TypedField<>(LocalDateTime.class, "parcel_sign_time");
        TypedField<String> PARCEL_SIGN_USER_NAME = new TypedField<>(String.class, "parcel_sign_user_name");
        TypedField<Long> DELETE_TOKEN = new TypedField<>(Long.class, "delete_token");
        TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "seller_org_code");
        TypedField<String> PURCHASER_ORG_CODE = new TypedField<>(String.class, "purchaser_org_code");
        TypedField<String> AUDIT_NAME = new TypedField<>(String.class, "audit_name");
        TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "purchaser_bank_account");
        TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "check_status");
        TypedField<String> TAX_RATE = new TypedField<>(String.class, "tax_rate");
        TypedField<LocalDateTime> MAKEOUT_TIME = new TypedField<>(LocalDateTime.class, "makeout_time");
        TypedField<String> AUTO_CHECK_STATUS = new TypedField<>(String.class, "auto_check_status");
        TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "settlement_no");
        TypedField<LocalDateTime> UPLOAD_TIME = new TypedField<>(LocalDateTime.class, "upload_time");
        TypedField<Long> EXTERNAL_BIZ_ORDER_ID = new TypedField<>(Long.class, "external_biz_order_id");
        TypedField<String> EXT26 = new TypedField<>(String.class, "ext26");
        TypedField<String> EXT27 = new TypedField<>(String.class, "ext27");
        TypedField<String> EXT28 = new TypedField<>(String.class, "ext28");
        TypedField<String> EXT29 = new TypedField<>(String.class, "ext29");
        TypedField<String> EXT30 = new TypedField<>(String.class, "ext30");
        TypedField<String> EXT31 = new TypedField<>(String.class, "ext31");
        TypedField<String> EXT32 = new TypedField<>(String.class, "ext32");
        TypedField<String> EXT33 = new TypedField<>(String.class, "ext33");
        TypedField<String> EXT34 = new TypedField<>(String.class, "ext34");
        TypedField<String> EXT35 = new TypedField<>(String.class, "ext35");
        TypedField<String> EXT36 = new TypedField<>(String.class, "ext36");
        TypedField<String> EXT37 = new TypedField<>(String.class, "ext37");
        TypedField<String> EXT38 = new TypedField<>(String.class, "ext38");
        TypedField<String> EXT39 = new TypedField<>(String.class, "ext39");
        TypedField<String> EXT40 = new TypedField<>(String.class, "ext40");
        TypedField<String> AUTO_CHECK_NOTE = new TypedField<>(String.class, "auto_check_note");
        TypedField<LocalDateTime> AUTO_CHECK_TIME = new TypedField<>(LocalDateTime.class, "auto_check_time");
        TypedField<String> TRANSFER_TAG = new TypedField<>(String.class, "transfer_tag");
        TypedField<String> SCAN_BACK_FLAG = new TypedField<>(String.class, "scan_back_flag");
        TypedField<String> MATCH_BATCH_NO = new TypedField<>(String.class, "match_batch_no");
        TypedField<String> RED_RELATION_STATUS = new TypedField<>(String.class, "red_relation_status");
        TypedField<String> MATCH_REMARK = new TypedField<>(String.class, "match_remark");
        TypedField<LocalDateTime> MATCH_TIME = new TypedField<>(LocalDateTime.class, "match_time");
        TypedField<String> LOCK_STATUS = new TypedField<>(String.class, "lock_status");
    }
    public interface BizOrderItem {
        static Long id() {
            return 1810595754272624641L;
        }
        static String code() {
            return "bizOrderItem";
        }
        TypedField<String> BIZ_ORDER_ITEM_NO = new TypedField<>(String.class, "biz_order_item_no");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<Long> LOCK_FLAG = new TypedField<>(Long.class, "lock_flag");
        TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "biz_order_no");
        TypedField<Long> BATCH_NO = new TypedField<>(Long.class, "batch_no");
        TypedField<Long> RULE_ID = new TypedField<>(Long.class, "rule_id");
        TypedField<String> BIZ_ORDER_TYPE = new TypedField<>(String.class, "biz_order_type");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> ITEM_CODE = new TypedField<>(String.class, "item_code");
        TypedField<String> ITEM_NAME = new TypedField<>(String.class, "item_name");
        TypedField<String> SPLIT_CODE = new TypedField<>(String.class, "split_code");
        TypedField<String> ITEM_TYPE_CODE = new TypedField<>(String.class, "item_type_code");
        TypedField<String> ITEM_SHORT_NAME = new TypedField<>(String.class, "item_short_name");
        TypedField<String> ITEM_SPEC = new TypedField<>(String.class, "item_spec");
        TypedField<BigDecimal> UNIT_PRICE_WITH_TAX = new TypedField<>(BigDecimal.class, "unit_price_with_tax");
        TypedField<BigDecimal> UNIT_PRICE = new TypedField<>(BigDecimal.class, "unit_price");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "outter_discount_with_tax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "outter_discount_without_tax");
        TypedField<BigDecimal> OUTTER_DISCOUNT_TAX = new TypedField<>(BigDecimal.class, "outter_discount_tax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "inner_discount_with_tax");
        TypedField<BigDecimal> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "inner_discount_without_tax");
        TypedField<BigDecimal> INNER_DISCOUNT_TAX = new TypedField<>(BigDecimal.class, "inner_discount_tax");
        TypedField<BigDecimal> OUTTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "outter_prepay_amount_with_tax");
        TypedField<BigDecimal> OUTTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "outter_prepay_amount_without_tax");
        TypedField<BigDecimal> OUTTER_PREPAY_AMOUNT_TAX = new TypedField<>(BigDecimal.class, "outter_prepay_amount_tax");
        TypedField<BigDecimal> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "inner_prepay_amount_with_tax");
        TypedField<BigDecimal> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "inner_prepay_amount_without_tax");
        TypedField<BigDecimal> INNER_PREPAY_AMOUNT_TAX = new TypedField<>(BigDecimal.class, "inner_prepay_amount_tax");
        TypedField<BigDecimal> QUANTITY = new TypedField<>(BigDecimal.class, "quantity");
        TypedField<String> QUANTITY_UNIT = new TypedField<>(String.class, "quantity_unit");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> ALREADY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "already_amount_with_tax");
        TypedField<BigDecimal> ALREADY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "already_amount_without_tax");
        TypedField<BigDecimal> ALREADY_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "already_tax_amount");
        TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "abandon_freeze_amount_with_tax");
        TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "abandon_freeze_amount_without_tax");
        TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "abandon_freeze_amount_tax_amount");
        TypedField<BigDecimal> TAX_RATE = new TypedField<>(BigDecimal.class, "tax_rate");
        TypedField<String> TAX_PRE = new TypedField<>(String.class, "tax_pre");
        TypedField<String> TAX_PRE_CON = new TypedField<>(String.class, "tax_pre_con");
        TypedField<String> ZERO_TAX = new TypedField<>(String.class, "zero_tax");
        TypedField<BigDecimal> DEDUCTIONS = new TypedField<>(BigDecimal.class, "deductions");
        TypedField<String> STATUS = new TypedField<>(String.class, "status");
        TypedField<Long> MODIFY_MARK = new TypedField<>(Long.class, "modify_mark");
        TypedField<String> GOODS_TAX_NO = new TypedField<>(String.class, "goods_tax_no");
        TypedField<String> TAX_CONVERT_CODE = new TypedField<>(String.class, "tax_convert_code");
        TypedField<String> GOODS_NO_VER = new TypedField<>(String.class, "goods_no_ver");
        TypedField<String> LARGE_CATEGORY_NAME = new TypedField<>(String.class, "large_category_name");
        TypedField<String> MEDIAN_CATEGORY_NAME = new TypedField<>(String.class, "median_category_name");
        TypedField<String> SMALL_CATEGORY_NAME = new TypedField<>(String.class, "small_category_name");
        TypedField<String> ORIGIN = new TypedField<>(String.class, "origin");
        TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "customer_no");
        TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "sys_org_id");
        TypedField<String> REMARK = new TypedField<>(String.class, "remark");
        TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "seller_tenant_id");
        TypedField<String> EXT1 = new TypedField<>(String.class, "ext1");
        TypedField<String> EXT2 = new TypedField<>(String.class, "ext2");
        TypedField<String> EXT3 = new TypedField<>(String.class, "ext3");
        TypedField<String> EXT4 = new TypedField<>(String.class, "ext4");
        TypedField<String> EXT5 = new TypedField<>(String.class, "ext5");
        TypedField<String> EXT6 = new TypedField<>(String.class, "ext6");
        TypedField<String> EXT7 = new TypedField<>(String.class, "ext7");
        TypedField<String> EXT8 = new TypedField<>(String.class, "ext8");
        TypedField<String> EXT9 = new TypedField<>(String.class, "ext9");
        TypedField<String> EXT10 = new TypedField<>(String.class, "ext10");
        TypedField<String> EXT11 = new TypedField<>(String.class, "ext11");
        TypedField<String> EXT12 = new TypedField<>(String.class, "ext12");
        TypedField<String> EXT13 = new TypedField<>(String.class, "ext13");
        TypedField<String> EXT14 = new TypedField<>(String.class, "ext14");
        TypedField<String> EXT15 = new TypedField<>(String.class, "ext15");
        TypedField<String> EXT16 = new TypedField<>(String.class, "ext16");
        TypedField<String> EXT17 = new TypedField<>(String.class, "ext17");
        TypedField<String> EXT18 = new TypedField<>(String.class, "ext18");
        TypedField<String> EXT19 = new TypedField<>(String.class, "ext19");
        TypedField<String> EXT20 = new TypedField<>(String.class, "ext20");
        TypedField<String> SPECIAL_ITEM_TYPE = new TypedField<>(String.class, "special_item_type");
        TypedField<Long> EXTERNAL_BIZ_ORDER_ITEM_ID = new TypedField<>(Long.class, "external_biz_order_item_id");
        TypedField<String> TRANSFER_TAG = new TypedField<>(String.class, "transfer_tag");
        /**
         * 对一关联关系 关联对象 bizOrder
         */
        TypedField<Long> BILL_ITEM_AND_BILL_MAIN_RELATION_ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.id");
        /**
         * 对一关联对象信息
         */
        interface ToOneRel {
            interface BILL_ITEM_AND_BILL_MAIN_RELATION {
                static String code () {
                    return "billItemAndBillMainRelation" ;
                }
                TypedField<String> BIZ_ORDER_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.biz_order_no");
                TypedField<String> COOPERATE_FLAG = new TypedField<>(String.class, "billItemAndBillMainRelation.cooperate_flag");
                TypedField<String> WAYBILL_NUMBER = new TypedField<>(String.class, "billItemAndBillMainRelation.waybill_number");
                TypedField<LocalDateTime> BILL_SIGN_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.bill_sign_time");
                TypedField<String> BILL_SIGN_USER_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.bill_sign_user_name");
                TypedField<String> IS_QUALIFIED = new TypedField<>(String.class, "billItemAndBillMainRelation.is_qualified");
                TypedField<Long> ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.id");
                TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.tenant_id");
                TypedField<String> TENANT_CODE = new TypedField<>(String.class, "billItemAndBillMainRelation.tenant_code");
                TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.create_time");
                TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.update_time");
                TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.create_user_id");
                TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.update_user_id");
                TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.create_user_name");
                TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.update_user_name");
                TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "billItemAndBillMainRelation.delete_flag");
                TypedField<String> ORIGIN_BIZ_ORDER_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.origin_biz_order_no");
                TypedField<String> SELLER_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.seller_no");
                TypedField<String> SELLER_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.seller_name");
                TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.seller_tax_no");
                TypedField<String> SELLER_TEL = new TypedField<>(String.class, "billItemAndBillMainRelation.seller_tel");
                TypedField<String> SELLER_ADDRESS = new TypedField<>(String.class, "billItemAndBillMainRelation.seller_address");
                TypedField<String> SELLER_BANK_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.seller_bank_name");
                TypedField<String> SELLER_BANK_ACCOUNT = new TypedField<>(String.class, "billItemAndBillMainRelation.seller_bank_account");
                TypedField<Long> SELLER_TENANT_ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.seller_tenant_id");
                TypedField<Long> SELLER_ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.seller_id");
                TypedField<String> PURCHASER_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.purchaser_no");
                TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.purchaser_name");
                TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.purchaser_tax_no");
                TypedField<String> PURCHASER_TEL = new TypedField<>(String.class, "billItemAndBillMainRelation.purchaser_tel");
                TypedField<String> PURCHASER_ADDRESS = new TypedField<>(String.class, "billItemAndBillMainRelation.purchaser_address");
                TypedField<String> PURCHASER_BANK_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.purchaser_bank_name");
                TypedField<Long> PURCHASER_ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.purchaser_id");
                TypedField<String> BUSINESS_BILL_TYPE = new TypedField<>(String.class, "billItemAndBillMainRelation.business_bill_type");
                TypedField<String> TAX_INVOICE_SOURCE = new TypedField<>(String.class, "billItemAndBillMainRelation.tax_invoice_source");
                TypedField<String> SYSTEM_ORIG = new TypedField<>(String.class, "billItemAndBillMainRelation.system_orig");
                TypedField<String> BIZ_ORDER_TYPE = new TypedField<>(String.class, "billItemAndBillMainRelation.biz_order_type");
                TypedField<String> RECEIPT_TYPE = new TypedField<>(String.class, "billItemAndBillMainRelation.receipt_type");
                TypedField<String> PRICE_METHOD = new TypedField<>(String.class, "billItemAndBillMainRelation.price_method");
                TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.amount_with_tax");
                TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.amount_without_tax");
                TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.tax_amount");
                TypedField<BigDecimal> ORIGIN_AMOUNT = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.origin_amount");
                TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.already_make_amount_with_tax");
                TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.already_make_amount_without_tax");
                TypedField<BigDecimal> ALREADY_MAKE_AMOUNT_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.already_make_amount_tax_amount");
                TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.abandon_freeze_amount_with_tax");
                TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.abandon_freeze_amount_without_tax");
                TypedField<BigDecimal> ABANDON_FREEZE_AMOUNT_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.abandon_freeze_amount_tax_amount");
                TypedField<BigDecimal> DISCOUNT_WITH_TAX_TOTAL = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.discount_with_tax_total");
                TypedField<BigDecimal> DISCOUNT_WITHOUT_TAX_TOTAL = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.discount_without_tax_total");
                TypedField<BigDecimal> DISCOUNT_TAX_AMOUNT_TOTAL = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.discount_tax_amount_total");
                TypedField<BigDecimal> OUTTER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.outter_discount_with_tax");
                TypedField<BigDecimal> OUTTER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.outter_discount_without_tax");
                TypedField<BigDecimal> INNER_DISCOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.inner_discount_with_tax");
                TypedField<BigDecimal> INNER_DISCOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.inner_discount_without_tax");
                TypedField<BigDecimal> OUTTER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.outter_prepay_amount_with_tax");
                TypedField<BigDecimal> OUTTER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.outter_prepay_amount_without_tax");
                TypedField<BigDecimal> INNER_PREPAY_AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.inner_prepay_amount_with_tax");
                TypedField<BigDecimal> INNER_PREPAY_AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.inner_prepay_amount_without_tax");
                TypedField<String> UPLOAD_CONFIRM_FLAG = new TypedField<>(String.class, "billItemAndBillMainRelation.upload_confirm_flag");
                TypedField<String> RECEIVE_CONFIRM_FLAG = new TypedField<>(String.class, "billItemAndBillMainRelation.receive_confirm_flag");
                TypedField<String> MAKEOUT_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.makeout_status");
                TypedField<String> STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.status");
                TypedField<Long> MODIFY_MARK = new TypedField<>(Long.class, "billItemAndBillMainRelation.modify_mark");
                TypedField<String> COOPERATE_MODIFY_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.cooperate_modify_status");
                TypedField<String> ORIGIN_INVOICE_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.origin_invoice_no");
                TypedField<String> ORIGIN_INVOICE_CODE = new TypedField<>(String.class, "billItemAndBillMainRelation.origin_invoice_code");
                TypedField<String> ORIGIN_INVOICE_TYPE = new TypedField<>(String.class, "billItemAndBillMainRelation.origin_invoice_type");
                TypedField<String> ORIGIN_PAPER_DRAW_DATE = new TypedField<>(String.class, "billItemAndBillMainRelation.origin_paper_draw_date");
                TypedField<String> RED_NOTIFICATION = new TypedField<>(String.class, "billItemAndBillMainRelation.red_notification");
                TypedField<String> CHECKER_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.checker_name");
                TypedField<String> CASHIER_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.cashier_name");
                TypedField<String> INVOICER_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.invoicer_name");
                TypedField<String> RECEIVE_USER_EMAIL = new TypedField<>(String.class, "billItemAndBillMainRelation.receive_user_email");
                TypedField<String> RECEIVE_USER_TEL = new TypedField<>(String.class, "billItemAndBillMainRelation.receive_user_tel");
                TypedField<Long> SYS_ORG_ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.sys_org_id");
                TypedField<String> USING_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.using_status");
                TypedField<String> CUSTOMER_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.customer_no");
                TypedField<String> ADDRESSEE = new TypedField<>(String.class, "billItemAndBillMainRelation.addressee");
                TypedField<String> ADDRESSEE_TEL = new TypedField<>(String.class, "billItemAndBillMainRelation.addressee_tel");
                TypedField<String> ADDRESSEE_PROVINCE = new TypedField<>(String.class, "billItemAndBillMainRelation.addressee_province");
                TypedField<String> ADDRESSEE_CITY = new TypedField<>(String.class, "billItemAndBillMainRelation.addressee_city");
                TypedField<String> ADDRESSEE_COUNTY = new TypedField<>(String.class, "billItemAndBillMainRelation.addressee_county");
                TypedField<String> DIRECTION = new TypedField<>(String.class, "billItemAndBillMainRelation.direction");
                TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "billItemAndBillMainRelation.invoice_type");
                TypedField<String> LOGISTIC_REMARK = new TypedField<>(String.class, "billItemAndBillMainRelation.logistic_remark");
                TypedField<String> REMARK = new TypedField<>(String.class, "billItemAndBillMainRelation.remark");
                TypedField<String> EXT1 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext1");
                TypedField<String> EXT2 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext2");
                TypedField<String> EXT3 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext3");
                TypedField<String> EXT4 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext4");
                TypedField<String> EXT5 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext5");
                TypedField<String> EXT6 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext6");
                TypedField<String> EXT7 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext7");
                TypedField<String> EXT8 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext8");
                TypedField<String> EXT9 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext9");
                TypedField<String> EXT10 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext10");
                TypedField<String> EXT11 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext11");
                TypedField<String> EXT12 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext12");
                TypedField<String> EXT13 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext13");
                TypedField<String> EXT14 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext14");
                TypedField<String> EXT15 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext15");
                TypedField<String> EXT16 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext16");
                TypedField<String> EXT17 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext17");
                TypedField<String> EXT18 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext18");
                TypedField<String> EXT19 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext19");
                TypedField<String> EXT20 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext20");
                TypedField<String> EXT21 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext21");
                TypedField<String> EXT22 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext22");
                TypedField<String> EXT23 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext23");
                TypedField<String> EXT24 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext24");
                TypedField<String> EXT25 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext25");
                TypedField<String> AUDIT_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.audit_status");
                TypedField<String> SYSTEM_ORIG_TYPE = new TypedField<>(String.class, "billItemAndBillMainRelation.system_orig_type");
                TypedField<String> APPLY_INVALID_FLAG = new TypedField<>(String.class, "billItemAndBillMainRelation.apply_invalid_flag");
                TypedField<String> MATCH_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.match_status");
                TypedField<String> MAKING_REASON = new TypedField<>(String.class, "billItemAndBillMainRelation.making_reason");
                TypedField<String> IMPORT_BATCH_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.import_batch_no");
                TypedField<String> POS_DATE = new TypedField<>(String.class, "billItemAndBillMainRelation.pos_date");
                TypedField<Long> CHANNEL = new TypedField<>(Long.class, "billItemAndBillMainRelation.channel");
                TypedField<String> PROCESS_REMARK = new TypedField<>(String.class, "billItemAndBillMainRelation.process_remark");
                TypedField<String> PURCHASER_TYPE = new TypedField<>(String.class, "billItemAndBillMainRelation.purchaser_type");
                TypedField<LocalDateTime> AUDIT_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.audit_time");
                TypedField<String> AUTH_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.auth_status");
                TypedField<LocalDateTime> CHECK_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.check_time");
                TypedField<LocalDateTime> AUTH_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.auth_time");
                TypedField<String> RECOG_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.recog_status");
                TypedField<LocalDateTime> RECOG_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.recog_time");
                TypedField<String> IS_NEED_AUTH = new TypedField<>(String.class, "billItemAndBillMainRelation.is_need_auth");
                TypedField<BigDecimal> EFFECTIVE_TAX_AMOUNT = new TypedField<>(BigDecimal.class, "billItemAndBillMainRelation.effective_tax_amount");
                TypedField<String> EXCEPTION_TYPE = new TypedField<>(String.class, "billItemAndBillMainRelation.exception_type");
                TypedField<String> EXCEPTION_REMARK = new TypedField<>(String.class, "billItemAndBillMainRelation.exception_remark");
                TypedField<LocalDateTime> PARCEL_SIGN_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.parcel_sign_time");
                TypedField<String> PARCEL_SIGN_USER_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.parcel_sign_user_name");
                TypedField<Long> DELETE_TOKEN = new TypedField<>(Long.class, "billItemAndBillMainRelation.delete_token");
                TypedField<String> SELLER_ORG_CODE = new TypedField<>(String.class, "billItemAndBillMainRelation.seller_org_code");
                TypedField<String> PURCHASER_ORG_CODE = new TypedField<>(String.class, "billItemAndBillMainRelation.purchaser_org_code");
                TypedField<String> AUDIT_NAME = new TypedField<>(String.class, "billItemAndBillMainRelation.audit_name");
                TypedField<String> PURCHASER_BANK_ACCOUNT = new TypedField<>(String.class, "billItemAndBillMainRelation.purchaser_bank_account");
                TypedField<String> CHECK_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.check_status");
                TypedField<String> TAX_RATE = new TypedField<>(String.class, "billItemAndBillMainRelation.tax_rate");
                TypedField<LocalDateTime> MAKEOUT_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.makeout_time");
                TypedField<String> AUTO_CHECK_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.auto_check_status");
                TypedField<String> SETTLEMENT_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.settlement_no");
                TypedField<LocalDateTime> UPLOAD_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.upload_time");
                TypedField<Long> EXTERNAL_BIZ_ORDER_ID = new TypedField<>(Long.class, "billItemAndBillMainRelation.external_biz_order_id");
                TypedField<String> EXT26 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext26");
                TypedField<String> EXT27 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext27");
                TypedField<String> EXT28 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext28");
                TypedField<String> EXT29 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext29");
                TypedField<String> EXT30 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext30");
                TypedField<String> EXT31 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext31");
                TypedField<String> EXT32 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext32");
                TypedField<String> EXT33 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext33");
                TypedField<String> EXT34 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext34");
                TypedField<String> EXT35 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext35");
                TypedField<String> EXT36 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext36");
                TypedField<String> EXT37 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext37");
                TypedField<String> EXT38 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext38");
                TypedField<String> EXT39 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext39");
                TypedField<String> EXT40 = new TypedField<>(String.class, "billItemAndBillMainRelation.ext40");
                TypedField<String> AUTO_CHECK_NOTE = new TypedField<>(String.class, "billItemAndBillMainRelation.auto_check_note");
                TypedField<LocalDateTime> AUTO_CHECK_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.auto_check_time");
                TypedField<String> TRANSFER_TAG = new TypedField<>(String.class, "billItemAndBillMainRelation.transfer_tag");
                TypedField<String> SCAN_BACK_FLAG = new TypedField<>(String.class, "billItemAndBillMainRelation.scan_back_flag");
                TypedField<String> MATCH_BATCH_NO = new TypedField<>(String.class, "billItemAndBillMainRelation.match_batch_no");
                TypedField<String> RED_RELATION_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.red_relation_status");
                TypedField<String> MATCH_REMARK = new TypedField<>(String.class, "billItemAndBillMainRelation.match_remark");
                TypedField<LocalDateTime> MATCH_TIME = new TypedField<>(LocalDateTime.class, "billItemAndBillMainRelation.match_time");
                TypedField<String> LOCK_STATUS = new TypedField<>(String.class, "billItemAndBillMainRelation.lock_status");
            }
        }
    }
    public interface InvoiceView {
        static Long id() {
            return 1810595756160061442L;
        }
        static String code() {
            return "invoiceView";
        }
        TypedField<String> INVOICE_CODE = new TypedField<>(String.class, "invoice_code");
        TypedField<String> INVOICE_NO = new TypedField<>(String.class, "invoice_no");
        TypedField<String> BILL_INVOICE_TYPE = new TypedField<>(String.class, "bill_invoice_type");
        TypedField<LocalDateTime> PAPER_DREW_DATE = new TypedField<>(LocalDateTime.class, "paper_drew_date");
        TypedField<String> PURCHASER_NAME = new TypedField<>(String.class, "purchaser_name");
        TypedField<String> SELLER_NAME = new TypedField<>(String.class, "seller_name");
        TypedField<String> SELLER_TAX_NO = new TypedField<>(String.class, "seller_tax_no");
        TypedField<String> PURCHASER_TAX_NO = new TypedField<>(String.class, "purchaser_tax_no");
        TypedField<BigDecimal> AMOUNT_WITHOUT_TAX = new TypedField<>(BigDecimal.class, "amount_without_tax");
        TypedField<BigDecimal> TAX_AMOUNT = new TypedField<>(BigDecimal.class, "tax_amount");
        TypedField<BigDecimal> AMOUNT_WITH_TAX = new TypedField<>(BigDecimal.class, "amount_with_tax");
        TypedField<Long> ID = new TypedField<>(Long.class, "id");
        TypedField<Long> TENANT_ID = new TypedField<>(Long.class, "tenant_id");
        TypedField<String> TENANT_CODE = new TypedField<>(String.class, "tenant_code");
        TypedField<LocalDateTime> CREATE_TIME = new TypedField<>(LocalDateTime.class, "create_time");
        TypedField<LocalDateTime> UPDATE_TIME = new TypedField<>(LocalDateTime.class, "update_time");
        TypedField<Long> CREATE_USER_ID = new TypedField<>(Long.class, "create_user_id");
        TypedField<Long> UPDATE_USER_ID = new TypedField<>(Long.class, "update_user_id");
        TypedField<String> CREATE_USER_NAME = new TypedField<>(String.class, "create_user_name");
        TypedField<String> UPDATE_USER_NAME = new TypedField<>(String.class, "update_user_name");
        TypedField<String> DELETE_FLAG = new TypedField<>(String.class, "delete_flag");
        TypedField<String> INVOICE_TYPE = new TypedField<>(String.class, "invoice_type");
        TypedField<String> INVOICE_STATUS = new TypedField<>(String.class, "invoice_status");
    }
}
