package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.validator;

import com.xforceplus.ultraman.app.purchaseresaleservice.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderOperateType.class)) {
            isValid = null != BizOrderOperateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderOperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(RelatedFlag.class)) {
            isValid = null != RelatedFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RelatedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderEntryRuleType.class)) {
            isValid = null != BizOrderEntryRuleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderEntryRuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatus.class)) {
            isValid = null != ConversionStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConversionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PricingMethod.class)) {
            isValid = null != PricingMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PricingMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OriginalType.class)) {
            isValid = null != OriginalType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OriginalType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = null != InvoiceColor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionType.class)) {
            isValid = null != ExceptionType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ExceptionType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsQualified.class)) {
            isValid = null != IsQualified.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsQualified.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = null != CooperateFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessBillType.class)) {
            isValid = null != BusinessBillType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessBillType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceType.class)) {
            isValid = null != BillInvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = null != PriceMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptType.class)) {
            isValid = null != ReceiptType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiptType.class.getSimpleName());
            }
        }
        if(clazz.equals(UsingStatus.class)) {
            isValid = null != UsingStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UsingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateModifyStatus.class)) {
            isValid = null != CooperateModifyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CooperateModifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = null != BillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MakeoutStatus.class)) {
            isValid = null != MakeoutStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MakeoutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadConfirmFlag.class)) {
            isValid = null != UploadConfirmFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, UploadConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveConfirmFlag.class)) {
            isValid = null != ReceiveConfirmFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ReceiveConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaserType.class)) {
            isValid = null != PurchaserType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PurchaserType.class.getSimpleName());
            }
        }
        if(clazz.equals(MakingReason.class)) {
            isValid = null != MakingReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MakingReason.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyInvalidFlag.class)) {
            isValid = null != ApplyInvalidFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApplyInvalidFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigType.class)) {
            isValid = null != SystemOrigType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SystemOrigType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = null != AuditStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillAuthStatus.class)) {
            isValid = null != BillAuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillAuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = null != IsNeedAuth.fromCode(value);
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(BillRecogStatus.class)) {
            isValid = null != BillRecogStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BillRecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoCheckStatus.class)) {
            isValid = null != AutoCheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AutoCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ScanBackFlag.class)) {
            isValid = null != ScanBackFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ScanBackFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(RedRelationStatus.class)) {
            isValid = null != RedRelationStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedRelationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatus.class)) {
            isValid = null != LockStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LockStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemTypeCode.class)) {
            isValid = null != ItemTypeCode.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ItemTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = null != TaxPre.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemStatus.class)) {
            isValid = null != ItemStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ItemStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialItemType.class)) {
            isValid = null != SpecialItemType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SpecialItemType.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemOrigin.class)) {
            isValid = null != ItemOrigin.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ItemOrigin.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderHistoryStatus.class)) {
            isValid = null != BizOrderHistoryStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderHistoryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedApplyStatus.class)) {
            isValid = null != RedApplyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedApplyReason.class)) {
            isValid = null != RedApplyReason.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedApplyReason.class.getSimpleName());
            }
        }
        if(clazz.equals(PreApplyStatus.class)) {
            isValid = null != PreApplyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PreApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderException.class)) {
            isValid = null != BizOrderException.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderException.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatusView.class)) {
            isValid = null != InvoiceStatusView.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatusView.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeView.class)) {
            isValid = null != InvoiceTypeView.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceTypeView.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSourceView.class)) {
            isValid = null != TaxInvoiceSourceView.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSourceView.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
