package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.validator;

import com.xforceplus.ultraman.app.purchaseresaleservice.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-07-12
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(FlowStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FlowStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SnapshotFormat.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderOperateType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BizOrderOperateType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BizOrderOperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(RelatedFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RelatedFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RelatedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderEntryRuleType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BizOrderEntryRuleType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BizOrderEntryRuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ConversionStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ConversionStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(PricingMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PricingMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PricingMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(OriginalType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != OriginalType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, OriginalType.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColor.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(ExceptionType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ExceptionType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ExceptionType.class.getSimpleName());
            }
        }
        if(clazz.equals(IsQualified.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsQualified.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsQualified.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CooperateFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CooperateFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessBillType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessBillType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessBillType.class.getSimpleName());
            }
        }
        if(clazz.equals(BillInvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillInvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillInvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(PriceMethod.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PriceMethod.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PriceMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiptType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiptType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiptType.class.getSimpleName());
            }
        }
        if(clazz.equals(UsingStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UsingStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UsingStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CooperateModifyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CooperateModifyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CooperateModifyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MakeoutStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MakeoutStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MakeoutStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(UploadConfirmFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != UploadConfirmFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, UploadConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(ReceiveConfirmFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ReceiveConfirmFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ReceiveConfirmFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(PurchaserType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PurchaserType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PurchaserType.class.getSimpleName());
            }
        }
        if(clazz.equals(MakingReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MakingReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MakingReason.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApplyInvalidFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApplyInvalidFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApplyInvalidFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(SystemOrigType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SystemOrigType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SystemOrigType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuditStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuditStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuditStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BillAuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillAuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillAuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(IsNeedAuth.class)) {
            isValid = vals.stream()
                    .filter(val -> null != IsNeedAuth.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, IsNeedAuth.class.getSimpleName());
            }
        }
        if(clazz.equals(BillRecogStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BillRecogStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BillRecogStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AutoCheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AutoCheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AutoCheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ScanBackFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ScanBackFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ScanBackFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(RedRelationStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedRelationStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedRelationStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LockStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LockStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemTypeCode.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ItemTypeCode.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ItemTypeCode.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxPre.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ZeroTax.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ItemStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ItemStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SpecialItemType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SpecialItemType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SpecialItemType.class.getSimpleName());
            }
        }
        if(clazz.equals(ItemOrigin.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ItemOrigin.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ItemOrigin.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderHistoryStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BizOrderHistoryStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BizOrderHistoryStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedApplyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedApplyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedApplyReason.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedApplyReason.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedApplyReason.class.getSimpleName());
            }
        }
        if(clazz.equals(PreApplyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PreApplyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PreApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderException.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BizOrderException.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BizOrderException.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatusView.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatusView.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatusView.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceTypeView.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceTypeView.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceTypeView.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSourceView.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSourceView.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSourceView.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
