package com.xforceplus.ultraman.app.purchaseresaleservice.metadata.validator;

import com.xforceplus.ultraman.app.purchaseresaleservice.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.purchaseresaleservice.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-12-25
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderOperateType.class)) {
            isValid = null != BizOrderOperateType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderOperateType.class.getSimpleName());
            }
        }
        if(clazz.equals(RelatedFlag.class)) {
            isValid = null != RelatedFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RelatedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderEntryRuleType.class)) {
            isValid = null != BizOrderEntryRuleType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderEntryRuleType.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(ConversionStatus.class)) {
            isValid = null != ConversionStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ConversionStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
