package com.xforceplus.ultraman.app.purchaseresaleservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaseresaleservice.entity.BizOrderOriginalInfo;
import com.xforceplus.ultraman.app.purchaseresaleservice.service.IBizOrderOriginalInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-27
 */
@RestController
public class BizOrderOriginalInfoController {

  @Autowired
  private IBizOrderOriginalInfoService bizOrderOriginalInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderOriginalInfo ${table.comment}
   * @return
   */
  @GetMapping("/bizorderoriginalinfos" )
  public XfR getBizOrderOriginalInfos(XfPage page, BizOrderOriginalInfo bizOrderOriginalInfo) {
    return XfR.ok(bizOrderOriginalInfoServiceImpl.page(page, Wrappers.query(bizOrderOriginalInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderoriginalinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderOriginalInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOrderOriginalInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizorderoriginalinfos")
  public XfR save(@RequestBody BizOrderOriginalInfo bizOrderOriginalInfo) {
     return XfR.ok(bizOrderOriginalInfoServiceImpl.save(bizOrderOriginalInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOrderOriginalInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizorderoriginalinfos/{id}")
  public XfR putUpdate(@RequestBody BizOrderOriginalInfo bizOrderOriginalInfo,@PathVariable Long id) {
      bizOrderOriginalInfo.setId(id);
      return XfR.ok(bizOrderOriginalInfoServiceImpl.updateById(bizOrderOriginalInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOrderOriginalInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizorderoriginalinfos/{id}")
  public XfR patchUpdate(@RequestBody BizOrderOriginalInfo bizOrderOriginalInfo,@PathVariable Long id) {
      BizOrderOriginalInfo upbizOrderOriginalInfo = bizOrderOriginalInfoServiceImpl.getById(id);
      if(upbizOrderOriginalInfo != null){
        upbizOrderOriginalInfo = ObjectCopyUtils.copyProperties(bizOrderOriginalInfo,upbizOrderOriginalInfo,true);
      }
      return XfR.ok(bizOrderOriginalInfoServiceImpl.updateById(upbizOrderOriginalInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderoriginalinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderOriginalInfoServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderoriginalinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_original_info");
     params.put("request", condition);

     return XfR.ok(bizOrderOriginalInfoServiceImpl.querys(params));
  }

}
