package com.xforceplus.ultraman.app.purchaseresaleservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaseresaleservice.entity.PurchaseInvoiceBaseInfo;
import com.xforceplus.ultraman.app.purchaseresaleservice.service.IPurchaseInvoiceBaseInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-27
 */
@RestController
public class PurchaseInvoiceBaseInfoController {

  @Autowired
  private IPurchaseInvoiceBaseInfoService purchaseInvoiceBaseInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param purchaseInvoiceBaseInfo ${table.comment}
   * @return
   */
  @GetMapping("/purchaseinvoicebaseinfos" )
  public XfR getPurchaseInvoiceBaseInfos(XfPage page, PurchaseInvoiceBaseInfo purchaseInvoiceBaseInfo) {
    return XfR.ok(purchaseInvoiceBaseInfoServiceImpl.page(page, Wrappers.query(purchaseInvoiceBaseInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/purchaseinvoicebaseinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(purchaseInvoiceBaseInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param purchaseInvoiceBaseInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/purchaseinvoicebaseinfos")
  public XfR save(@RequestBody PurchaseInvoiceBaseInfo purchaseInvoiceBaseInfo) {
     return XfR.ok(purchaseInvoiceBaseInfoServiceImpl.save(purchaseInvoiceBaseInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param purchaseInvoiceBaseInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/purchaseinvoicebaseinfos/{id}")
  public XfR putUpdate(@RequestBody PurchaseInvoiceBaseInfo purchaseInvoiceBaseInfo,@PathVariable Long id) {
      purchaseInvoiceBaseInfo.setId(id);
      return XfR.ok(purchaseInvoiceBaseInfoServiceImpl.updateById(purchaseInvoiceBaseInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param purchaseInvoiceBaseInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/purchaseinvoicebaseinfos/{id}")
  public XfR patchUpdate(@RequestBody PurchaseInvoiceBaseInfo purchaseInvoiceBaseInfo,@PathVariable Long id) {
      PurchaseInvoiceBaseInfo uppurchaseInvoiceBaseInfo = purchaseInvoiceBaseInfoServiceImpl.getById(id);
      if(uppurchaseInvoiceBaseInfo != null){
        uppurchaseInvoiceBaseInfo = ObjectCopyUtils.copyProperties(purchaseInvoiceBaseInfo,uppurchaseInvoiceBaseInfo,true);
      }
      return XfR.ok(purchaseInvoiceBaseInfoServiceImpl.updateById(uppurchaseInvoiceBaseInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/purchaseinvoicebaseinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(purchaseInvoiceBaseInfoServiceImpl.removeById(id));
  }

  @PostMapping("/purchaseinvoicebaseinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "purchase_invoice_base_info");
     params.put("request", condition);

     return XfR.ok(purchaseInvoiceBaseInfoServiceImpl.querys(params));
  }

}
