package com.xforceplus.ultraman.app.purchaseresaleservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaseresaleservice.entity.SaleInvoiceBaseInfo;
import com.xforceplus.ultraman.app.purchaseresaleservice.service.ISaleInvoiceBaseInfoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-12-27
 */
@RestController
public class SaleInvoiceBaseInfoController {

  @Autowired
  private ISaleInvoiceBaseInfoService saleInvoiceBaseInfoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param saleInvoiceBaseInfo ${table.comment}
   * @return
   */
  @GetMapping("/saleinvoicebaseinfos" )
  public XfR getSaleInvoiceBaseInfos(XfPage page, SaleInvoiceBaseInfo saleInvoiceBaseInfo) {
    return XfR.ok(saleInvoiceBaseInfoServiceImpl.page(page, Wrappers.query(saleInvoiceBaseInfo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/saleinvoicebaseinfos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(saleInvoiceBaseInfoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param saleInvoiceBaseInfo ${table.comment}
   * @return XfR
   */
  @PostMapping("/saleinvoicebaseinfos")
  public XfR save(@RequestBody SaleInvoiceBaseInfo saleInvoiceBaseInfo) {
     return XfR.ok(saleInvoiceBaseInfoServiceImpl.save(saleInvoiceBaseInfo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param saleInvoiceBaseInfo ${table.comment}
   * @return XfR
   */
  @PutMapping("/saleinvoicebaseinfos/{id}")
  public XfR putUpdate(@RequestBody SaleInvoiceBaseInfo saleInvoiceBaseInfo,@PathVariable Long id) {
      saleInvoiceBaseInfo.setId(id);
      return XfR.ok(saleInvoiceBaseInfoServiceImpl.updateById(saleInvoiceBaseInfo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param saleInvoiceBaseInfo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/saleinvoicebaseinfos/{id}")
  public XfR patchUpdate(@RequestBody SaleInvoiceBaseInfo saleInvoiceBaseInfo,@PathVariable Long id) {
      SaleInvoiceBaseInfo upsaleInvoiceBaseInfo = saleInvoiceBaseInfoServiceImpl.getById(id);
      if(upsaleInvoiceBaseInfo != null){
        upsaleInvoiceBaseInfo = ObjectCopyUtils.copyProperties(saleInvoiceBaseInfo,upsaleInvoiceBaseInfo,true);
      }
      return XfR.ok(saleInvoiceBaseInfoServiceImpl.updateById(upsaleInvoiceBaseInfo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/saleinvoicebaseinfos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(saleInvoiceBaseInfoServiceImpl.removeById(id));
  }

  @PostMapping("/saleinvoicebaseinfos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sale_invoice_base_info");
     params.put("request", condition);

     return XfR.ok(saleInvoiceBaseInfoServiceImpl.querys(params));
  }

}
