package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 国税异常发票凭证feign客户端
 *
 * @author ultraman
 * @date 2024-07-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.AbnormalInvoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface AbnormalInvoiceFeignApi {

  /**
   * 通过id查询国税异常发票凭证
   * @param  id
   * @return R
   */
  @GetMapping("/abnormalInvoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增国税异常发票凭证
   * @param abnormalInvoice 国税异常发票凭证
   * @return R
   */
  @PostMapping("/abnormalInvoice/add")
  public R save(@RequestBody AbnormalInvoice abnormalInvoice);

  /**
   * 修改国税异常发票凭证
   * @param abnormalInvoice 国税异常发票凭证
   * @return R
   */
  @PostMapping("/abnormalInvoice/update")
  public R updateById(@RequestBody AbnormalInvoice abnormalInvoice);

  /**
   * 通过id删除国税异常发票凭证
   * @param  id
   * @return R
   */
  @DeleteMapping("/abnormalInvoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}