package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 发票不合规履历feign客户端
 *
 * @author ultraman
 * @date 2024-07-30
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceNoComplianceLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceNoComplianceLogFeignApi {

  /**
   * 通过id查询发票不合规履历
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceNoComplianceLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票不合规履历
   * @param invoiceNoComplianceLog 发票不合规履历
   * @return R
   */
  @PostMapping("/invoiceNoComplianceLog/add")
  public R save(@RequestBody InvoiceNoComplianceLog invoiceNoComplianceLog);

  /**
   * 修改发票不合规履历
   * @param invoiceNoComplianceLog 发票不合规履历
   * @return R
   */
  @PostMapping("/invoiceNoComplianceLog/update")
  public R updateById(@RequestBody InvoiceNoComplianceLog invoiceNoComplianceLog);

  /**
   * 通过id删除发票不合规履历
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceNoComplianceLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}