package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 配单下发模块feign客户端
 *
 * @author ultraman
 * @date 2024-11-22
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.MatchBatchOperateHistory;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface MatchBatchOperateHistoryFeignApi {

  /**
   * 通过id查询配单下发模块
   * @param  id
   * @return R
   */
  @GetMapping("/matchBatchOperateHistory/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增配单下发模块
   * @param matchBatchOperateHistory 配单下发模块
   * @return R
   */
  @PostMapping("/matchBatchOperateHistory/add")
  public R save(@RequestBody MatchBatchOperateHistory matchBatchOperateHistory);

  /**
   * 修改配单下发模块
   * @param matchBatchOperateHistory 配单下发模块
   * @return R
   */
  @PostMapping("/matchBatchOperateHistory/update")
  public R updateById(@RequestBody MatchBatchOperateHistory matchBatchOperateHistory);

  /**
   * 通过id删除配单下发模块
   * @param  id
   * @return R
   */
  @DeleteMapping("/matchBatchOperateHistory/del/{id}" )
  public R removeById(@PathVariable Long id);

}