package com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.controller;


/**
 * 发票明细展示对象feign客户端
 *
 * @author ultraman
 * @date 2025-10-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.purchaserinvoicemanagesaas.entity.InvoiceItemView;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "purchaser-invoice-manage-saas")
public interface InvoiceItemViewFeignApi {

  /**
   * 通过id查询发票明细展示对象
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceItemView/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增发票明细展示对象
   * @param invoiceItemView 发票明细展示对象
   * @return R
   */
  @PostMapping("/invoiceItemView/add")
  public R save(@RequestBody InvoiceItemView invoiceItemView);

  /**
   * 修改发票明细展示对象
   * @param invoiceItemView 发票明细展示对象
   * @return R
   */
  @PostMapping("/invoiceItemView/update")
  public R updateById(@RequestBody InvoiceItemView invoiceItemView);

  /**
   * 通过id删除发票明细展示对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceItemView/del/{id}" )
  public R removeById(@PathVariable Long id);

}